# Fix for Symlink node_modules Issue

## Problem
Your hosting provider is using a **symlinked `node_modules`** directory, which Next.js/Turbopack cannot handle. This causes:
- `Error: Cannot find module 'next'`
- `Symlink node_modules is invalid, it points out of the filesystem root`
- Turbopack crashes

## Solution Steps

### Step 1: Remove Symlinked node_modules

SSH into your server and run:

```bash
cd /home/betruixl/betreviews.world

# Check if node_modules is a symlink
ls -la | grep node_modules

# If it's a symlink, remove it
rm -rf node_modules

# Also remove package-lock.json to ensure clean install
rm -f package-lock.json
```

### Step 2: Install Dependencies Locally

```bash
# Make sure you're in the virtual environment
source /home/betruixl/nodevenv/betreviews.world/22/bin/activate

# Install dependencies locally (not as symlink)
npm install --no-optional

# This will create a real node_modules directory in your app folder
```

### Step 3: Build the Application

```bash
# Build the Next.js application
npm run build

# This creates the .next directory required for production
```

### Step 4: Verify Installation

```bash
# Check that node_modules exists and is NOT a symlink
ls -la node_modules

# Should show a directory (d), not a symlink (l)
# If it shows 'l' (symlink), repeat Step 1 and 2
```

### Step 5: Restart Application

In your hosting control panel:
1. Click **"STOP APP"**
2. Wait 10 seconds
3. Click **"RESTART"**
4. Wait 30-60 seconds for startup

## Alternative: Use Next.js Default Server

If the symlink issue persists, you can use Next.js's built-in server instead of `server.js`:

1. In your hosting control panel, change the **Application startup file** from `server.js` to:
   ```
   node_modules/.bin/next start
   ```

2. Or update `package.json` start script and use:
   ```
   npm start
   ```

## If Issues Persist

### Check Virtual Environment

Your hosting provider uses a virtual environment. Make sure:

1. **Virtual environment is activated** before running npm commands:
   ```bash
   source /home/betruixl/nodevenv/betreviews.world/22/bin/activate
   ```

2. **Node.js version matches**: Should be 22.18.0 (as shown in your panel)

3. **Install in the correct location**: Make sure you're in `/home/betruixl/betreviews.world` when running npm install

### Manual Installation Script

Create a file `install.sh` in your app root:

```bash
#!/bin/bash
cd /home/betruixl/betreviews.world
source /home/betruixl/nodevenv/betreviews.world/22/bin/activate

# Remove symlink if exists
if [ -L node_modules ]; then
    echo "Removing symlinked node_modules..."
    rm -rf node_modules
fi

# Install dependencies
echo "Installing dependencies..."
npm install --no-optional

# Build application
echo "Building application..."
npm run build

echo "Installation complete!"
```

Make it executable and run:
```bash
chmod +x install.sh
./install.sh
```

## Verification Checklist

After following the steps, verify:

- [ ] `node_modules` exists and is a **directory** (not symlink)
- [ ] `node_modules/next` exists
- [ ] `.next` directory exists (created by `npm run build`)
- [ ] Application starts without errors
- [ ] No "Cannot find module 'next'" errors
- [ ] No "Symlink node_modules is invalid" errors

## Important Notes

1. **Never use symlinked node_modules** with Next.js in production
2. **Always build** before starting: `npm run build`
3. **Use the virtual environment** when running npm commands
4. **Check logs** if issues persist - they will show the exact error

