import type { ThemeId } from "@/types/theme";
import { getThemeId, DEFAULT_THEME } from "@/types/theme";

/**
 * Color themes
 * Theme 1: #d95f8c (button/badges), #870339 (welcome bonus), #0d0d0d (card background)
 * Theme 2: #9f95e5 (button/badges), #494d6d (welcome bonus), #010326 (card background)
 * Theme 3: #bf9f98 (button/badges), #510f3d (welcome bonus), #00010d (card background)
 * Theme 4: #8bd1c3 (button/badges), #0388a6 (welcome bonus), #14231d (card background)
 * Theme 5: #cca097 (button/badges), #592816 (welcome bonus), #0d0d0d (card background)
 * Theme 6: #f2bbc9 (button/badges), #8082a6 (welcome bonus), #282e40 (card background)
 * Theme 7: #c5c8d9 (button/badges), #2f5973 (welcome bonus), #470913 (card background)
 */
export function getColorTheme(themeId: ThemeId | string | null | undefined) {
  const theme = getThemeId(themeId);
  
  switch (theme) {
    case "1":
      return {
        buttonBadge: "#d95f8c",    // First color - Claim Now button and badges
        welcomeBonus: "#870339",    // Second color - Welcome bonus background
        cardBackground: "#0d0d0d",  // Third color - Partner card background
      };
    case "2":
      return {
        buttonBadge: "#9f95e5",
        welcomeBonus: "#494d6d",
        cardBackground: "#010326",
      };
    case "3":
      return {
        buttonBadge: "#bf9f98",
        welcomeBonus: "#510f3d",
        cardBackground: "#00010d",
      };
    case "4":
      return {
        buttonBadge: "#8bd1c3",
        welcomeBonus: "#0388a6",
        cardBackground: "#14231d",
      };
    case "5":
      return {
        buttonBadge: "#cca097",
        welcomeBonus: "#592816",
        cardBackground: "#0d0d0d",
      };
    case "6":
      return {
        buttonBadge: "#f2bbc9",
        welcomeBonus: "#8082a6",
        cardBackground: "#282e40",
      };
    case "7":
      return {
        buttonBadge: "#c5c8d9",
        welcomeBonus: "#2f5973",
        cardBackground: "#470913",
      };
    default:
      return {
        buttonBadge: "#9f95e5",
        welcomeBonus: "#494d6d",
        cardBackground: "#010326",
      };
  }
}

/**
 * Helper to convert hex to rgba
 */
export function hexToRgba(hex: string, alpha: number): string {
  const r = parseInt(hex.slice(1, 3), 16);
  const g = parseInt(hex.slice(3, 5), 16);
  const b = parseInt(hex.slice(5, 7), 16);
  return `rgba(${r}, ${g}, ${b}, ${alpha})`;
}

