import type { SiteInfo } from "@/types/data";

interface FooterProps {
  readonly siteInfo: SiteInfo;
}

export function Footer({ siteInfo }: FooterProps) {
  return (
    <footer className="border-t border-indigo-300/30 bg-gradient-to-br from-indigo-950 via-blue-950 to-indigo-950">
      <div className="mx-auto flex max-w-6xl flex-col gap-12 px-4 py-16 text-sm sm:flex-row sm:justify-between sm:px-6 lg:gap-16">
        <div className="space-y-4">
          <h3 className="text-lg font-bold text-white">Contacto</h3>
          <div className="space-y-3">
            <p>
              <span className="font-semibold text-white/80">Email:</span>{" "}
              <a 
                href={`mailto:${siteInfo.email}`} 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                {siteInfo.email}
              </a>
            </p>
            <p>
              <span className="font-semibold text-white/80">Telefone:</span>{" "}
              <a 
                href={`tel:${siteInfo.phone.replace(/\s+/g, "")}`} 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                {siteInfo.phone}
              </a>
            </p>
            <p>
              <span className="font-semibold text-white/80">Endereço:</span>{" "}
              <span className="text-white/70">{siteInfo.address}</span>
            </p>
          </div>
        </div>
        <div className="space-y-6">
          <div className="space-y-3">
            <h3 className="text-lg font-bold text-white">Conformidade</h3>
            <div className="flex gap-4">
              <a 
                href="/privacy" 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                Política de Privacidade
              </a>
              <span className="text-white/30">•</span>
              <a 
                href="/disclaimer" 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                Aviso Legal
              </a>
            </div>
          </div>
          <section id="privacy" aria-labelledby="privacy-heading" className="space-y-2 text-xs leading-relaxed text-white/60">
            <p id="privacy-heading" className="font-bold uppercase tracking-wider text-white/50">
              Política de Privacidade
            </p>
            <p>
              Nunca vendemos dados de utilizadores. As análises são anonimizadas e baseadas em consentimento para permanecerem em conformidade com as políticas do Google Ads.
            </p>
          </section>
          <section id="disclaimer" aria-labelledby="disclaimer-heading" className="space-y-2 text-xs leading-relaxed text-white/60">
            <p id="disclaimer-heading" className="font-bold uppercase tracking-wider text-white/50">
              Aviso Legal
            </p>
            <p>
              {siteInfo.siteName} promove operadores licenciados sempre que possível. As ofertas estão sujeitas a alterações e aplicam-se os termos e condições do operador.
            </p>
          </section>
          <div id="responsible" className="space-y-4">
            <h3 className="text-lg font-bold text-white">Jogo Responsável</h3>
            <div className="flex flex-wrap items-center justify-center gap-4 sm:gap-6">
              <a 
                href="https://www.srij.turismodeportugal.pt" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group flex items-center gap-2.5 rounded-lg border border-white/10 bg-white/5 px-4 py-2.5 transition-all duration-200 hover:border-blue-400/50 hover:bg-blue-500/10 hover:opacity-100 hover:shadow-lg hover:shadow-blue-500/20"
                aria-label="SRIJ – Serviço de Regulação e Inspeção de Jogos"
              >
                <div className="flex h-8 w-8 items-center justify-center rounded-full bg-blue-500/20 transition-colors group-hover:bg-blue-500/30">
                  <svg className="h-4 w-4 text-blue-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2.5}>
                    <path strokeLinecap="round" strokeLinejoin="round" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                  </svg>
                </div>
                <span className="font-medium text-white/90 transition-colors group-hover:text-white">SRIJ</span>
              </a>
              <a 
                href="https://www.icad.pt" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group flex items-center gap-2.5 rounded-lg border border-white/10 bg-white/5 px-4 py-2.5 transition-all duration-200 hover:border-pink-400/50 hover:bg-pink-500/10 hover:opacity-100 hover:shadow-lg hover:shadow-pink-500/20"
                aria-label="ICAD – Instituto para os Comportamentos Aditivos e as Dependências"
              >
                <div className="flex h-8 w-8 items-center justify-center rounded-full bg-pink-500/20 transition-colors group-hover:bg-pink-500/30">
                  <svg className="h-4 w-4 text-pink-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2.5}>
                    <path strokeLinecap="round" strokeLinejoin="round" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                  </svg>
                </div>
                <span className="font-medium text-white/90 transition-colors group-hover:text-white">ICAD</span>
              </a>
              <a 
                href="tel:1414" 
                className="group flex items-center gap-2.5 rounded-lg border border-white/10 bg-white/5 px-4 py-2.5 transition-all duration-200 hover:border-green-400/50 hover:bg-green-500/10 hover:opacity-100 hover:shadow-lg hover:shadow-green-500/20"
                aria-label="Linha Vida - 1414"
              >
                <div className="flex h-8 w-8 items-center justify-center rounded-full bg-green-500/20 transition-colors group-hover:bg-green-500/30">
                  <svg className="h-4 w-4 text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2.5}>
                    <path strokeLinecap="round" strokeLinejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                  </svg>
                </div>
                <span className="font-medium text-white/90 transition-colors group-hover:text-white">Linha Vida - 1414</span>
              </a>
              <a 
                href="https://www.jogadoresanonimos.pt" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group flex items-center gap-2.5 rounded-lg border border-white/10 bg-white/5 px-4 py-2.5 transition-all duration-200 hover:border-purple-400/50 hover:bg-purple-500/10 hover:opacity-100 hover:shadow-lg hover:shadow-purple-500/20"
                aria-label="Jogadores Anónimos"
              >
                <div className="flex h-8 w-8 items-center justify-center rounded-full bg-purple-500/20 transition-colors group-hover:bg-purple-500/30">
                  <svg className="h-4 w-4 text-purple-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2.5}>
                    <path strokeLinecap="round" strokeLinejoin="round" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                  </svg>
                </div>
                <span className="font-medium text-white/90 transition-colors group-hover:text-white">Jogadores Anónimos</span>
              </a>
              <div className="flex items-center gap-2.5 rounded-lg bg-gradient-to-r from-orange-500 via-orange-600 to-red-600 px-5 py-2.5 font-bold text-white shadow-lg shadow-orange-500/30 transition-all duration-200 hover:scale-105 hover:shadow-xl hover:shadow-orange-500/40">
                <svg className="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2.5}>
                  <path strokeLinecap="round" strokeLinejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                </svg>
                <span className="text-sm sm:text-base">Jogue com Responsabilidade</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="border-t border-white/10 bg-indigo-950/90">
        <div className="mx-auto max-w-6xl px-4 py-6 sm:px-6">
          <div className="mx-auto max-w-4xl rounded-2xl border-2 border-blue-500/40 bg-gradient-to-br from-blue-500/10 via-indigo-500/5 to-transparent p-6 shadow-lg backdrop-blur-sm">
            <div className="flex items-start gap-4">
              <div className="flex-shrink-0">
                <div className="flex h-10 w-10 items-center justify-center rounded-full bg-blue-500/20">
                  <svg className="h-6 w-6 text-blue-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                    <path strokeLinecap="round" strokeLinejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                  </svg>
                </div>
              </div>
              <div className="flex-1 space-y-3">
                <div>
                  <h4 className="mb-2 text-sm font-bold text-blue-100 sm:text-base">
                    Aviso Importante
                  </h4>
                  <p className="text-xs leading-relaxed text-blue-50/90 sm:text-sm">
                    Este site contém links de afiliados. Podemos receber uma comissão se se registar através dos nossos links. Por favor, aposte com responsabilidade e aposte apenas o que pode perder. O jogo pode ser viciante.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="border-t border-white/5 py-4 text-center">
        <p className="text-xs text-white/60">
          © {new Date().getFullYear()} {siteInfo.siteName}. Todos os direitos reservados.
        </p>
        </div>
      </div>
    </footer>
  );
}
