import { NextRequest, NextResponse } from 'next/server';
import { incrementClick, getClicks } from '@/lib/clicks';

export async function POST(request: NextRequest) {
  try {
    const { partnerName }: { partnerName: string } = await request.json();
    
    if (!partnerName) {
      return NextResponse.json(
        { error: 'Partner name is required' },
        { 
          status: 400,
          headers: {
            'Cache-Control': 'no-store, no-cache, must-revalidate',
          },
        }
      );
    }
    
    incrementClick(partnerName);
    
    return NextResponse.json(
      { success: true },
      {
        headers: {
          'Cache-Control': 'no-store, no-cache, must-revalidate',
        },
      }
    );
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to track click' },
      { 
        status: 500,
        headers: {
          'Cache-Control': 'no-store, no-cache, must-revalidate',
        },
      }
    );
  }
}

export async function GET() {
  try {
    const clicks = getClicks();
    return NextResponse.json(clicks, {
      headers: {
        'Cache-Control': 'public, s-maxage=10, stale-while-revalidate=60',
      },
    });
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to get clicks' },
      { 
        status: 500,
        headers: {
          'Cache-Control': 'no-store, no-cache, must-revalidate',
        },
      }
    );
  }
}

