"use client";

import type { ThemeId } from "@/types/theme";
import { getColorTheme, hexToRgba } from "@/lib/color-theme";

interface ContactAddressItemProps {
  readonly address: string;
  readonly label: string;
  readonly theme: ThemeId;
}

export function ContactAddressItem({ address, label, theme }: ContactAddressItemProps) {
  const colorTheme = getColorTheme(theme);

  return (
    <li 
      className="group relative flex flex-col overflow-hidden rounded-xl border p-4 shadow-lg transition-all duration-300 ease-out sm:rounded-2xl sm:p-5"
      style={{
        borderColor: hexToRgba(colorTheme.welcomeBonus, 0.25),
        background: `linear-gradient(to bottom right, rgba(0, 0, 0, 0.9), ${hexToRgba(colorTheme.cardBackground, 0.85)}, rgba(0, 0, 0, 0.9))`,
        boxShadow: `0 10px 25px -5px rgba(0, 0, 0, 0.5), 0 0 0 1px ${hexToRgba(colorTheme.welcomeBonus, 0.1)}`,
      }}
      onMouseEnter={(e) => {
        e.currentTarget.style.borderColor = hexToRgba(colorTheme.welcomeBonus, 0.35);
        e.currentTarget.style.boxShadow = `0 10px 25px -5px ${hexToRgba(colorTheme.welcomeBonus, 0.2)}, 0 0 0 1px ${hexToRgba(colorTheme.welcomeBonus, 0.15)}`;
      }}
      onMouseLeave={(e) => {
        e.currentTarget.style.borderColor = hexToRgba(colorTheme.welcomeBonus, 0.25);
        e.currentTarget.style.boxShadow = `0 10px 25px -5px rgba(0, 0, 0, 0.5), 0 0 0 1px ${hexToRgba(colorTheme.welcomeBonus, 0.1)}`;
      }}
    >
      <div 
        className="absolute inset-0 transition-all duration-300" 
        style={{
          background: `linear-gradient(to bottom right, ${hexToRgba(colorTheme.welcomeBonus, 0)}, ${hexToRgba(colorTheme.welcomeBonus, 0)}, ${hexToRgba(colorTheme.welcomeBonus, 0)})`,
        }}
      />
      <div className="relative z-10 mb-2.5 flex items-center gap-2.5 sm:mb-3 sm:gap-3">
        <div 
          className="flex h-9 w-9 shrink-0 items-center justify-center rounded-lg text-white shadow-md transition-transform duration-300 group-hover:scale-110 sm:h-10 sm:w-10"
          style={{
            background: `linear-gradient(to bottom right, ${colorTheme.welcomeBonus}, ${colorTheme.welcomeBonus})`,
            boxShadow: `0 4px 12px -2px ${hexToRgba(colorTheme.welcomeBonus, 0.4)}, inset 0 1px 0 rgba(255, 255, 255, 0.1)`,
          }}
        >
          <svg className="h-4 w-4 sm:h-5 sm:w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2.5}>
            <path strokeLinecap="round" strokeLinejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
            <path strokeLinecap="round" strokeLinejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
          </svg>
        </div>
        <span className="text-[10px] font-bold uppercase tracking-wider text-white/70 sm:text-xs">
          {label}
        </span>
      </div>
      <p className="relative z-10 text-sm font-semibold text-white/90 sm:text-base">{address}</p>
    </li>
  );
}

