import type { LanguageCode } from "@/types/language";

/**
 * Translation keys for the entire application
 * Organized by component/section for easy maintenance
 */
export interface Translations {
  readonly hero: {
    readonly badge: string;
    readonly tagline: string;
    readonly slidingText: readonly string[];
  };
  readonly features: {
    readonly badge: string;
    readonly title: string;
    readonly subtitle: string;
    readonly ultraRapido: {
      readonly title: string;
      readonly description: string;
    };
    readonly conforme: {
      readonly title: string;
      readonly description: string;
    };
    readonly mobileFirst: {
      readonly title: string;
      readonly description: string;
    };
    readonly transparente: {
      readonly title: string;
      readonly description: string;
    };
  };
  readonly partners: {
    readonly heading: string;
    readonly claimNow: string;
    readonly terms: string;
    readonly welcomeBonus: string;
  };
  readonly footer: {
    readonly contact: string;
    readonly email: string;
    readonly phone: string;
    readonly address: string;
    readonly compliance: string;
    readonly quickLinks: string;
    readonly home: string;
    readonly about: string;
    readonly contactPage: string;
    readonly legal: string;
    readonly terms: string;
    readonly privacy: string;
    readonly responsibleGambling: string;
  };
  readonly navigation: {
    readonly home: string;
    readonly about: string;
    readonly contact: string;
  };
  readonly about: {
    readonly badge: string;
    readonly title: string;
    readonly subtitle: string;
    readonly mission: {
      readonly title: string;
      readonly description: string;
    };
    readonly compliance: {
      readonly title: string;
      readonly description: string;
    };
    readonly dataDriven: {
      readonly title: string;
      readonly description: string;
    };
    readonly commitment: {
      readonly title: string;
      readonly description: string;
    };
    readonly trust: {
      readonly title: string;
      readonly description: string;
    };
    readonly performance: {
      readonly title: string;
      readonly description: string;
    };
  };
  readonly contact: {
    readonly badge: string;
    readonly title: string;
    readonly subtitle: string;
    readonly formTitle: string;
    readonly formDescription: string;
    readonly contactDetails: string;
    readonly email: string;
    readonly phone: string;
    readonly address: string;
  };
  readonly privacy: {
    readonly title: string;
    readonly subtitle: string;
    readonly badge: string;
    readonly sections: {
      readonly informationWeCollect: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
      };
      readonly howWeUse: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
      };
      readonly dataProtection: {
        readonly title: string;
        readonly description: string;
      };
      readonly cookies: {
        readonly title: string;
        readonly description: string;
      };
      readonly thirdParty: {
        readonly title: string;
        readonly description: string;
      };
      readonly yourRights: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
        readonly contactText: string;
      };
      readonly changes: {
        readonly title: string;
        readonly description: string;
      };
      readonly contact: {
        readonly title: string;
        readonly description: string;
        readonly lastUpdated: string;
      };
    };
  };
  readonly disclaimer: {
    readonly title: string;
    readonly subtitle: string;
    readonly badge: string;
    readonly sections: {
      readonly general: {
        readonly title: string;
        readonly description: string;
      };
      readonly partnerOffers: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
        readonly recommendation: string;
      };
      readonly licensing: {
        readonly title: string;
        readonly description: string;
      };
      readonly affiliate: {
        readonly title: string;
        readonly description: string;
      };
      readonly noGuarantees: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
      };
      readonly responsible: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
        readonly helpText: string;
      };
      readonly ageRestrictions: {
        readonly title: string;
        readonly description: string;
      };
      readonly liability: {
        readonly title: string;
        readonly description: string;
        readonly items: readonly string[];
      };
      readonly contact: {
        readonly title: string;
        readonly description: string;
        readonly lastUpdated: string;
      };
    };
  };
  readonly faq: {
    readonly badge: string;
    readonly title: string;
    readonly subtitle: string;
    readonly items: readonly {
      readonly question: string;
      readonly answer: string;
    }[];
  };
  readonly positionLabels: readonly string[];
}

const translations: Record<LanguageCode, Translations> = {
  en: {
    hero: {
      badge: "Verified Partner Insights",
      tagline: "Top-Rated UK Betting Platforms",
      slidingText: [
        "Certified & Protected",
        "Same-Day Withdrawal Sites",
        "Minimal Documentation Required",
        "Privacy-First Gaming",
      ],
    },
    features: {
      badge: "Trusted Platform",
      title: "Why Trust ReviewMasters?",
      subtitle: "We are committed to providing you with the best betting experience",
      ultraRapido: {
        title: "Ultra-fast",
        description: "Core Web Vitals optimization in LCP, CLS and FID. Our platform loads in under 2 seconds, ensuring instant access to the best betting opportunities without delays or interruptions.",
      },
      conforme: {
        title: "Compliant",
        description: "Manual verification of partners to ensure compliance with Google Ads policies. Every operator undergoes rigorous screening for licensing, bonus terms clarity, and regulatory adherence before approval.",
      },
      mobileFirst: {
        title: "Mobile-first",
        description: "Material-inspired components that convert on any device. Optimized for smartphones and tablets with responsive design, ensuring seamless betting experiences whether you're at home or on the go.",
      },
      transparente: {
        title: "Transparent",
        description: "Clear disclosure of licensing status for responsible choices. We provide full transparency about operator credentials, bonus terms, and affiliate relationships so you can make informed decisions with confidence.",
      },
    },
    partners: {
      heading: "Top UK Betting Offers 2025",
      claimNow: "Claim Now",
      terms: "18+ Terms apply. Please bet responsibly.",
      welcomeBonus: "Welcome Bonus",
    },
    footer: {
      contact: "Contact",
      email: "Email:",
      phone: "Phone:",
      address: "Address:",
      compliance: "Compliance",
      quickLinks: "Quick Links",
      home: "Home",
      about: "About Us",
      contactPage: "Contact",
      legal: "Legal",
      terms: "Terms & Conditions",
      privacy: "Privacy Policy",
      responsibleGambling: "Responsible Gambling",
    },
    navigation: {
      home: "Home",
      about: "About",
      contact: "Contact",
    },
    about: {
      badge: "About Us",
      title: "About {siteName}",
      subtitle: "{siteName} exists to connect UK bettors with transparent and responsibly promoted offers from betting houses and sportsbooks. Our team analyzes each operator's compliance history, bonus terms, and mobile UX to ensure you can run Google Ads campaigns with confidence.",
      mission: {
        title: "Our Mission",
        description: "Advocate for safe and responsible gaming while helping partners create world-class acquisition journeys.",
      },
      compliance: {
        title: "Compliance First",
        description: "We audit creatives and landing pages against UKGC guidance and Google Ads policies before they're approved.",
      },
      dataDriven: {
        title: "Data-Driven Testing",
        description: "Performance dashboards and conversion data (linked to gclid) fuel weekly partner reviews.",
      },
      commitment: {
        title: "Our Commitment",
        description: "We are dedicated to creating a trusted platform that connects UK bettors with the best betting opportunities, maintaining the highest standards of compliance and transparency.",
      },
      trust: {
        title: "Trust & Transparency",
        description: "Each partner is carefully verified for licensing, clarity of bonus terms, and user experience quality. We believe in full transparency about operator status and offer details.",
      },
      performance: {
        title: "Performance Excellence",
        description: "Our platform is optimized for speed, mobile responsiveness, and conversion. We track performance metrics to continuously improve the betting partner experience.",
      },
    },
    contact: {
      badge: "Get in Touch",
      title: "Let's collaborate",
      subtitle: "Share your campaign goals and we'll recommend the best partner positioning, bonus, and tracking plan.",
      formTitle: "Send us a message",
      formDescription: "Fill out the form below and we'll get back to you within 24 hours.",
      contactDetails: "Contact Details",
      email: "Email",
      phone: "Phone",
      address: "Address",
    },
    privacy: {
      title: "Privacy Policy",
      subtitle: "Your privacy is important to us. This policy explains how we collect, use, and protect your information.",
      badge: "Legal",
      sections: {
        informationWeCollect: {
          title: "Information We Collect",
          description: "{siteName} collects minimal information necessary to provide our services. We may collect:",
          items: [
            "Contact information when you submit a form (name, email address)",
            "Usage data through anonymized analytics to improve our website",
            "Visitor tracking data (entry URLs, referer information, timestamps) to understand user behavior",
            "Click tracking data to analyze which partner links are clicked and improve our services",
            "Technical information such as IP address, browser type, and device information",
          ],
        },
        howWeUse: {
          title: "How We Use Your Information",
          description: "We use the information we collect to:",
          items: [
            "Respond to your inquiries and provide customer support",
            "Improve our website performance and user experience",
            "Track visitor interactions and click patterns to enhance our services",
            "Ensure compliance with Google Ads policies and UK gambling regulations",
            "Analyze website traffic patterns through anonymized data",
          ],
        },
        dataProtection: {
          title: "Data Protection",
          description: "We never sell user data. All analytics are anonymized and consent-based to remain compliant with Google Ads policies and GDPR requirements. We implement appropriate technical and organizational measures to protect your personal information.",
        },
        cookies: {
          title: "Cookies and Tracking",
          description: "Our website uses cookies and similar tracking technologies to analyze website traffic and improve user experience. We track visitor entry data and click interactions to understand how users navigate our site and improve our services. All tracking is anonymized and compliant with Google Ads policies. This data helps us enhance website functionality and user experience. You can control cookie preferences through your browser settings.",
        },
        thirdParty: {
          title: "Third-Party Services",
          description: "We may use third-party services for analytics and website functionality. These services are bound by their own privacy policies and are selected for their commitment to data protection and compliance.",
        },
        yourRights: {
          title: "Your Rights",
          description: "Under GDPR, you have the right to:",
          items: [
            "Access your personal data",
            "Request correction of inaccurate data",
            "Request deletion of your data",
            "Object to processing of your data",
            "Data portability",
          ],
          contactText: "To exercise these rights, contact us at",
        },
        changes: {
          title: "Changes to This Policy",
          description: "We may update this privacy policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the \"Last updated\" date.",
        },
        contact: {
          title: "Contact Us",
          description: "If you have questions about this privacy policy, contact us at",
          lastUpdated: "Last updated:",
        },
      },
    },
    disclaimer: {
      title: "Terms & Conditions",
      subtitle: "Important information about our betting partner recommendations and terms of use.",
      badge: "Legal",
      sections: {
        general: {
          title: "General Information",
          description: "{siteName} promotes licensed operators whenever possible. All offers, bonuses, and promotions from betting partners are subject to change and are governed by each individual operator's terms and conditions. We strive to provide accurate and up-to-date information, but we cannot guarantee the availability or terms of any offer.",
        },
        partnerOffers: {
          title: "Partner Offers",
          description: "All welcome bonuses, promotions, and offers displayed on {siteName} are subject to:",
          items: [
            "The terms and conditions of the respective betting operator",
            "Eligibility requirements established by each operator",
            "Availability at the time of your registration",
            "Geographic restrictions and licensing requirements",
          ],
          recommendation: "We recommend that you review the full terms and conditions on the operator's website before claiming any offer.",
        },
        licensing: {
          title: "Licensing Status",
          description: "{siteName} displays licensing information for betting partners when available. We make every effort to verify licensing status, but operators may hold licenses from different jurisdictions. It is your responsibility to verify that any operator is licensed and regulated in your jurisdiction before placing bets.",
        },
        affiliate: {
          title: "Affiliate Relationships",
          description: "{siteName} maintains affiliate relationships with the betting operators featured on our platform. This means we may receive compensation when users click and register with these operators. This does not affect our commitment to providing honest and transparent recommendations.",
        },
        noGuarantees: {
          title: "No Guarantees",
          description: "{siteName} does not guarantee:",
          items: [
            "The availability of any specific offer or bonus",
            "The accuracy of bonus terms or promotional details",
            "Winning outcomes or betting results",
            "The performance or reliability of any betting operator",
          ],
        },
        responsible: {
          title: "Responsible Gambling",
          description: "{siteName} is committed to promoting responsible gambling. We encourage all users to:",
          items: [
            "Bet only with money you can afford to lose",
            "Set limits on your gambling activities",
            "Seek help if gambling becomes a problem",
            "Familiarize yourself with responsible gambling resources",
          ],
          helpText: "If you need help with gambling problems, contact organizations such as GamCare, BeGambleAware, or your local support services.",
        },
        ageRestrictions: {
          title: "Age Restrictions",
          description: "All betting operators require users to be at least 18 years old (or the legal gambling age in your jurisdiction). {siteName} does not promote gambling to minors. By using our platform, you confirm that you meet the legal age requirements for gambling in your jurisdiction.",
        },
        liability: {
          title: "Limitation of Liability",
          description: "{siteName} will not be liable for any losses, damages, or issues arising from:",
          items: [
            "Your use of any betting operator's services",
            "Changes to offers, bonuses, or terms by operators",
            "Disputes between you and betting operators",
            "Technical issues or website unavailability",
          ],
        },
        contact: {
          title: "Contact Us",
          description: "If you have questions about this legal notice, contact us at",
          lastUpdated: "Last updated:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Frequently Asked Questions",
      subtitle: "Find answers to common questions about our platform and betting partner recommendations.",
      items: [
        {
          question: "How do you select betting partners?",
          answer: "We carefully vet all betting partners based on licensing status, bonus terms clarity, user experience quality, and compliance with Google Ads policies. Only operators that meet our strict standards are featured on our platform.",
        },
        {
          question: "Are all partners licensed?",
          answer: "We prioritize licensed operators and clearly display licensing information when available. However, licensing status can vary by jurisdiction. We recommend verifying that any operator is licensed in your jurisdiction before placing bets.",
        },
        {
          question: "Do you receive compensation from partners?",
          answer: "Yes, we maintain affiliate relationships with featured operators. This means we may receive compensation when users click and register through our links. This does not affect our commitment to providing honest, transparent recommendations.",
        },
        {
          question: "How often are partner offers updated?",
          answer: "We regularly review and update partner information, bonuses, and offers. However, all offers are subject to change by operators, so we recommend checking the operator's website for the most current terms before claiming any bonus.",
        },
        {
          question: "Is my personal information safe?",
          answer: "Yes, we take data protection seriously. We never sell user data, and all analytics are anonymized. We comply with GDPR requirements and Google Ads policies to ensure your privacy is protected.",
        },
        {
          question: "Can I trust your recommendations?",
          answer: "Absolutely. Our recommendations are based on thorough analysis of licensing, compliance history, bonus terms, and user experience. We maintain transparency about affiliate relationships and prioritize your best interests.",
        },
      ],
    },
    positionLabels: [
      "Top Choice",
      "Editor's Choice",
      "Best Match",
      "Recommended",
      "Great Option",
      "Sixth Option",
      "Seventh Option",
      "Eighth Option",
      "Ninth Option",
      "Tenth Option",
      "Eleventh Option",
    ],
  },
  pt: {
    hero: {
      badge: "Insights de Parceiros Verificados",
      tagline: "Top Casas de Apostas em Portugal",
      slidingText: [
        "Certificado e Protegido",
        "Sites de Levantamento no Mesmo Dia",
        "Documentação Mínima Necessária",
        "Jogos com Privacidade em Primeiro",
      ],
    },
    features: {
      badge: "Plataforma Confiável",
      title: "Por que confiar no ReviewMasters?",
      subtitle: "Estamos comprometidos em proporcionar-lhe a melhor experiência de apostas",
      ultraRapido: {
        title: "Ultra-rápido",
        description: "Otimização Core Web Vitals em LCP, CLS e FID. A nossa plataforma carrega em menos de 2 segundos, garantindo acesso instantâneo às melhores oportunidades de apostas sem atrasos ou interrupções.",
      },
      conforme: {
        title: "Conforme",
        description: "Verificação manual de parceiros para garantir conformidade com as políticas do Google Ads. Cada operador passa por uma triagem rigorosa para licenciamento, clareza dos termos de bónus e aderência regulatória antes da aprovação.",
      },
      mobileFirst: {
        title: "Mobile-first",
        description: "Componentes inspirados no Material que convertem em qualquer dispositivo. Otimizado para smartphones e tablets com design responsivo, garantindo experiências de apostas perfeitas, quer esteja em casa ou em movimento.",
      },
      transparente: {
        title: "Transparente",
        description: "Divulgação clara do status de licenciamento para escolhas responsáveis. Fornecemos total transparência sobre credenciais de operadores, termos de bónus e relações de afiliados para que possa tomar decisões informadas com confiança.",
      },
    },
    partners: {
      heading: "Top Casas de Apostas em Portugal",
      claimNow: "Reclamar Agora",
      terms: "18+ Termos aplicam-se. Por favor, aposte com responsabilidade.",
      welcomeBonus: "Bónus de Boas-Vindas",
    },
    footer: {
      contact: "Contacto",
      email: "Email:",
      phone: "Telefone:",
      address: "Endereço:",
      compliance: "Conformidade",
      quickLinks: "Links Rápidos",
      home: "Início",
      about: "Sobre Nós",
      contactPage: "Contacto",
      legal: "Legal",
      terms: "Termos e Condições",
      privacy: "Política de Privacidade",
      responsibleGambling: "Jogo Responsável",
    },
    navigation: {
      home: "Início",
      about: "Sobre",
      contact: "Contacto",
    },
    about: {
      badge: "Sobre Nós",
      title: "Sobre o {siteName}",
      subtitle: "O {siteName} existe para conectar apostadores do Reino Unido com ofertas transparentes e responsavelmente promovidas de casas de apostas e casas de apostas desportivas. A nossa equipa analisa o histórico de conformidade, termos de bónus e UX móvel de cada operador para garantir que pode executar campanhas do Google Ads com confiança.",
      mission: {
        title: "A Nossa Missão",
        description: "Defender jogos seguros e responsáveis enquanto ajudamos parceiros a criar jornadas de aquisição de classe mundial.",
      },
      compliance: {
        title: "Conformidade em Primeiro",
        description: "Auditamos criativos e páginas de destino contra orientações da UKGC e políticas do Google Ads antes de serem aprovados.",
      },
      dataDriven: {
        title: "Testes Baseados em Dados",
        description: "Dashboards de desempenho e dados de conversão (ligados ao gclid) alimentam revisões semanais de parceiros.",
      },
      commitment: {
        title: "O Nosso Compromisso",
        description: "Estamos dedicados a criar uma plataforma confiável que conecta apostadores do Reino Unido com as melhores oportunidades de apostas, mantendo os mais altos padrões de conformidade e transparência.",
      },
      trust: {
        title: "Confiança e Transparência",
        description: "Cada parceiro é cuidadosamente verificado quanto ao licenciamento, clareza dos termos de bónus e qualidade da experiência do utilizador. Acreditamos na total transparência sobre o status do operador e detalhes da oferta.",
      },
      performance: {
        title: "Excelência de Desempenho",
        description: "A nossa plataforma está otimizada para velocidade, responsividade móvel e conversão. Acompanhamos métricas de desempenho para melhorar continuamente a experiência do parceiro de apostas.",
      },
    },
    contact: {
      badge: "Entre em Contacto",
      title: "Vamos colaborar",
      subtitle: "Partilhe os seus objetivos de campanha e recomendaremos o melhor posicionamento de parceiro, bónus e plano de rastreamento.",
      formTitle: "Envie-nos uma mensagem",
      formDescription: "Preencha o formulário abaixo e entraremos em contacto consigo no prazo de 24 horas.",
      contactDetails: "Detalhes de contacto",
      email: "Email",
      phone: "Telefone",
      address: "Endereço",
    },
    privacy: {
      title: "Política de Privacidade",
      subtitle: "A sua privacidade é importante para nós. Esta política explica como recolhemos, utilizamos e protegemos as suas informações.",
      badge: "Legal",
      sections: {
        informationWeCollect: {
          title: "Informações que Recolhemos",
          description: "{siteName} recolhe informações mínimas necessárias para fornecer os nossos serviços. Podemos recolher:",
          items: [
            "Informações de contacto quando submete um formulário (nome, endereço de email)",
            "Dados de utilização através de análises anonimizadas para melhorar o nosso website",
            "Dados de rastreamento de visitantes (URLs de entrada, informações de referência, timestamps) para entender o comportamento do utilizador",
            "Dados de rastreamento de cliques para analisar quais links de parceiros são clicados e melhorar os nossos serviços",
            "Informações técnicas como endereço IP, tipo de navegador e informações do dispositivo",
          ],
        },
        howWeUse: {
          title: "Como Utilizamos as Suas Informações",
          description: "Utilizamos as informações que recolhemos para:",
          items: [
            "Responder às suas consultas e fornecer suporte ao cliente",
            "Melhorar o desempenho do nosso website e experiência do utilizador",
            "Rastrear interações de visitantes e padrões de cliques para melhorar os nossos serviços",
            "Garantir conformidade com as políticas do Google Ads e regulamentos de jogo do Reino Unido",
            "Analisar padrões de tráfego do website através de dados anonimizados",
          ],
        },
        dataProtection: {
          title: "Proteção de Dados",
          description: "Nunca vendemos dados de utilizadores. Todas as análises são anonimizadas e baseadas em consentimento para permanecerem em conformidade com as políticas do Google Ads e requisitos do RGPD. Implementamos medidas técnicas e organizacionais apropriadas para proteger as suas informações pessoais.",
        },
        cookies: {
          title: "Cookies e Rastreamento",
          description: "O nosso website utiliza cookies e tecnologias de rastreamento semelhantes para analisar o tráfego do website e melhorar a experiência do utilizador. Rastreamos dados de entrada de visitantes e interações de cliques para entender como os utilizadores navegam no nosso site e melhorar os nossos serviços. Todo o rastreamento é anonimizado e está em conformidade com as políticas do Google Ads. Estes dados ajudam-nos a melhorar a funcionalidade do website e a experiência do utilizador. Pode controlar as preferências de cookies através das definições do seu navegador.",
        },
        thirdParty: {
          title: "Serviços de Terceiros",
          description: "Podemos utilizar serviços de terceiros para análises e funcionalidade do website. Estes serviços estão vinculados às suas próprias políticas de privacidade e são selecionados pelo seu compromisso com a proteção de dados e conformidade.",
        },
        yourRights: {
          title: "Os Seus Direitos",
          description: "Ao abrigo do RGPD, tem o direito de:",
          items: [
            "Aceder aos seus dados pessoais",
            "Solicitar correção de dados inexatos",
            "Solicitar eliminação dos seus dados",
            "Opor-se ao processamento dos seus dados",
            "Portabilidade de dados",
          ],
          contactText: "Para exercer estes direitos, contacte-nos em",
        },
        changes: {
          title: "Alterações a Esta Política",
          description: "Podemos atualizar esta política de privacidade de tempos a tempos. Notificá-lo-emos de quaisquer alterações publicando a nova política nesta página e atualizando a data de \"Última atualização\".",
        },
        contact: {
          title: "Contacte-nos",
          description: "Se tiver questões sobre esta política de privacidade, contacte-nos em",
          lastUpdated: "Última atualização:",
        },
      },
    },
    disclaimer: {
      title: "Aviso Legal",
      subtitle: "Informações importantes sobre as nossas recomendações de parceiros de apostas e termos de utilização.",
      badge: "Legal",
      sections: {
        general: {
          title: "Informações Gerais",
          description: "{siteName} promove operadores licenciados sempre que possível. Todas as ofertas, bónus e promoções de parceiros de apostas estão sujeitas a alterações e são regidas pelos termos e condições de cada operador individual. Esforçamo-nos por fornecer informações precisas e atualizadas, mas não podemos garantir a disponibilidade ou termos de qualquer oferta.",
        },
        partnerOffers: {
          title: "Ofertas de Parceiros",
          description: "Todos os bónus de boas-vindas, promoções e ofertas exibidas no {siteName} estão sujeitos a:",
          items: [
            "Os termos e condições do respetivo operador de apostas",
            "Requisitos de elegibilidade estabelecidos por cada operador",
            "Disponibilidade no momento do seu registo",
            "Restrições geográficas e requisitos de licenciamento",
          ],
          recommendation: "Recomendamos que revise os termos e condições completos no website do operador antes de reclamar qualquer oferta.",
        },
        licensing: {
          title: "Status de Licenciamento",
          description: "{siteName} exibe informações de licenciamento para parceiros de apostas quando disponíveis. Fazemos todos os esforços para verificar o status de licenciamento, mas os operadores podem possuir licenças de diferentes jurisdições. É sua responsabilidade verificar que qualquer operador está licenciado e regulamentado na sua jurisdição antes de fazer apostas.",
        },
        affiliate: {
          title: "Relações de Afiliados",
          description: "{siteName} mantém relações de afiliados com os operadores de apostas apresentados na nossa plataforma. Isto significa que podemos receber compensação quando os utilizadores clicam e se registam com estes operadores. Isto não afeta o nosso compromisso de fornecer recomendações honestas e transparentes.",
        },
        noGuarantees: {
          title: "Sem Garantias",
          description: "{siteName} não garante:",
          items: [
            "A disponibilidade de qualquer oferta ou bónus específico",
            "A precisão dos termos de bónus ou detalhes promocionais",
            "Resultados vencedores ou resultados de apostas",
            "O desempenho ou fiabilidade de qualquer operador de apostas",
          ],
        },
        responsible: {
          title: "Jogo Responsável",
          description: "{siteName} está comprometido em promover o jogo responsável. Encorajamos todos os utilizadores a:",
          items: [
            "Apostar apenas com dinheiro que pode perder",
            "Estabelecer limites nas suas atividades de jogo",
            "Procurar ajuda se o jogo se tornar um problema",
            "Familiarizar-se com recursos de jogo responsável",
          ],
          helpText: "Se precisar de ajuda com problemas de jogo, contacte organizações como GamCare, BeGambleAware ou os seus serviços de apoio locais.",
        },
        ageRestrictions: {
          title: "Restrições de Idade",
          description: "Todos os operadores de apostas exigem que os utilizadores tenham pelo menos 18 anos (ou a idade legal de jogo na sua jurisdição). {siteName} não promove o jogo a menores. Ao utilizar a nossa plataforma, confirma que atende aos requisitos de idade legal para jogar na sua jurisdição.",
        },
        liability: {
          title: "Limitação de Responsabilidade",
          description: "{siteName} não será responsável por quaisquer perdas, danos ou problemas decorrentes de:",
          items: [
            "A sua utilização dos serviços de qualquer operador de apostas",
            "Alterações a ofertas, bónus ou termos por operadores",
            "Disputas entre si e operadores de apostas",
            "Problemas técnicos ou indisponibilidade do website",
          ],
        },
        contact: {
          title: "Contacte-nos",
          description: "Se tiver questões sobre este aviso legal, contacte-nos em",
          lastUpdated: "Última atualização:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Perguntas Frequentes",
      subtitle: "Encontre respostas a perguntas comuns sobre a nossa plataforma e recomendações de parceiros de apostas.",
      items: [
        {
          question: "Como seleciona os parceiros de apostas?",
          answer: "Avaliamos cuidadosamente todos os parceiros de apostas com base no status de licenciamento, clareza dos termos de bónus, qualidade da experiência do utilizador e conformidade com as políticas do Google Ads. Apenas operadores que atendem aos nossos padrões rigorosos são apresentados na nossa plataforma.",
        },
        {
          question: "Todos os parceiros estão licenciados?",
          answer: "Priorizamos operadores licenciados e exibimos claramente informações de licenciamento quando disponíveis. No entanto, o status de licenciamento pode variar por jurisdição. Recomendamos verificar que qualquer operador está licenciado na sua jurisdição antes de fazer apostas.",
        },
        {
          question: "Recebe compensação dos parceiros?",
          answer: "Sim, mantemos relações de afiliados com os operadores apresentados. Isto significa que podemos receber compensação quando os utilizadores clicam e se registam através dos nossos links. Isto não afeta o nosso compromisso de fornecer recomendações honestas e transparentes.",
        },
        {
          question: "Com que frequência são atualizadas as ofertas dos parceiros?",
          answer: "Revimos e atualizamos regularmente as informações, bónus e ofertas dos parceiros. No entanto, todas as ofertas estão sujeitas a alterações pelos operadores, por isso recomendamos verificar o website do operador para os termos mais atuais antes de reclamar qualquer bónus.",
        },
        {
          question: "As minhas informações pessoais estão seguras?",
          answer: "Sim, levamos a proteção de dados a sério. Nunca vendemos dados de utilizadores e todas as análises são anonimizadas. Cumprimos os requisitos do RGPD e as políticas do Google Ads para garantir que a sua privacidade está protegida.",
        },
        {
          question: "Posso confiar nas suas recomendações?",
          answer: "Absolutamente. As nossas recomendações baseiam-se numa análise completa do licenciamento, histórico de conformidade, termos de bónus e experiência do utilizador. Mantemos transparência sobre relações de afiliados e priorizamos os seus melhores interesses.",
        },
      ],
    },
    positionLabels: [
      "Escolha Principal",
      "Escolha do Editor",
      "Melhor Correspondência",
      "Recomendado",
      "Ótima Opção",
      "Sexta Opção",
      "Sétima Opção",
      "Oitava Opção",
      "Nona Opção",
      "Décima Opção",
      "Décima Primeira Opção",
    ],
  },
  dk: {
    hero: {
      badge: "Verificerede Partner Indsigt",
      tagline: "Top-Rated Danske Betting Platforme",
      slidingText: [
        "Certificeret og Beskyttet",
        "Samme-Dag Hævningssider",
        "Minimal Dokumentation Påkrævet",
        "Privatlivs-Først Gaming",
      ],
    },
    features: {
      badge: "Pålidelig Platform",
      title: "Hvorfor stole på ReviewMasters?",
      subtitle: "Vi er forpligtet til at give dig den bedste betting oplevelse",
      ultraRapido: {
        title: "Ultra-hurtig",
        description: "Core Web Vitals optimering i LCP, CLS og FID. Vores platform indlæses på under 2 sekunder, hvilket sikrer øjeblikkelig adgang til de bedste bettingmuligheder uden forsinkelser eller afbrydelser.",
      },
      conforme: {
        title: "Overensstemmende",
        description: "Manuel verifikation af partnere for at sikre overensstemmelse med Google Ads politikker. Hver operatør gennemgår streng screening for licensering, klarhed i bonustermer og regulatorisk overholdelse før godkendelse.",
      },
      mobileFirst: {
        title: "Mobile-first",
        description: "Material-inspirerede komponenter, der konverterer på enhver enhed. Optimeret til smartphones og tablets med responsivt design, hvilket sikrer problemfri bettingoplevelser, uanset om du er hjemme eller på farten.",
      },
      transparente: {
        title: "Transparent",
        description: "Tydelig oplysning om licensstatus for ansvarlige valg. Vi giver fuld gennemsigtighed om operatørlegitimationer, bonustermer og affiliate-forhold, så du kan træffe informerede beslutninger med tillid.",
      },
    },
    partners: {
      heading: "Top Danske Betting Tilbud 2025",
      claimNow: "Gør Krav Nu",
      terms: "18+ Vilkår gælder. Spil venligst ansvarligt.",
      welcomeBonus: "Velkomstbonus",
    },
    footer: {
      contact: "Kontakt",
      email: "Email:",
      phone: "Telefon:",
      address: "Adresse:",
      compliance: "Overensstemmelse",
      quickLinks: "Hurtige Links",
      home: "Hjem",
      about: "Om Os",
      contactPage: "Kontakt",
      legal: "Juridisk",
      terms: "Vilkår og Betingelser",
      privacy: "Fortrolighedspolitik",
      responsibleGambling: "Ansvarligt Spil",
    },
    navigation: {
      home: "Hjem",
      about: "Om Os",
      contact: "Kontakt",
    },
    about: {
      badge: "Om Os",
      title: "Om {siteName}",
      subtitle: "{siteName} eksisterer for at forbinde danske spillere med gennemsigtige og ansvarligt promoverede tilbud fra bettinghuse og sportsbørs. Vores team analyserer hver operatørs overholdelseshistorik, bonustermer og mobil UX for at sikre, at du kan køre Google Ads-kampagner med tillid.",
      mission: {
        title: "Vores Mission",
        description: "Talsmand for sikkert og ansvarligt spil, mens vi hjælper partnere med at skabe verdensklasse erhvervelsesrejser.",
      },
      compliance: {
        title: "Overensstemmelse Først",
        description: "Vi reviderer kreativer og landingssider mod Spillemyndighedens vejledning og Google Ads-politikker, før de godkendes.",
      },
      dataDriven: {
        title: "Datadrevet Test",
        description: "Ydelsesdashboards og konverteringsdata (linket til gclid) driver ugentlige partnergennemgange.",
      },
      commitment: {
        title: "Vores Forpligtelse",
        description: "Vi er dedikerede til at skabe en pålidelig platform, der forbinder danske spillere med de bedste bettingmuligheder, mens vi opretholder de højeste standarder for overensstemmelse og gennemsigtighed.",
      },
      trust: {
        title: "Tillid og Gennemsigtighed",
        description: "Hver partner verificeres omhyggeligt for licensering, klarhed i bonustermer og brugeroplevelseskvalitet. Vi tror på fuld gennemsigtighed om operatørstatus og tilbudsdetaljer.",
      },
      performance: {
        title: "Ydelsesekspertise",
        description: "Vores platform er optimeret til hastighed, mobilresponsivitet og konvertering. Vi sporer ydelsesmålinger for kontinuerligt at forbedre bettingpartneroplevelsen.",
      },
    },
    contact: {
      badge: "Kom i Kontakt",
      title: "Lad os samarbejde",
      subtitle: "Del dine kampagnemål, og vi anbefaler den bedste partnerpositionering, bonus og sporing.",
      formTitle: "Send os en besked",
      formDescription: "Udfyld formularen nedenfor, og vi vender tilbage til dig inden for 24 timer.",
      contactDetails: "Kontaktoplysninger",
      email: "Email",
      phone: "Telefon",
      address: "Adresse",
    },
    privacy: {
      title: "Fortrolighedspolitik",
      subtitle: "Din privatliv er vigtigt for os. Denne politik forklarer, hvordan vi indsamler, bruger og beskytter dine oplysninger.",
      badge: "Juridisk",
      sections: {
        informationWeCollect: {
          title: "Oplysninger Vi Indsamler",
          description: "{siteName} indsamler minimale oplysninger, der er nødvendige for at levere vores tjenester. Vi kan indsamle:",
          items: [
            "Kontaktoplysninger, når du indsender en formular (navn, e-mailadresse)",
            "Brugsdata gennem anonymiserede analyser for at forbedre vores hjemmeside",
            "Besøgende sporedata (indgangs-URL'er, henvisningsinformationer, tidsstempler) for at forstå brugeradfærd",
            "Kliksporedata for at analysere, hvilke partnerlinks der klikkes på, og forbedre vores tjenester",
            "Tekniske oplysninger som IP-adresse, browsertype og enhedsoplysninger",
          ],
        },
        howWeUse: {
          title: "Hvordan Vi Bruger Dine Oplysninger",
          description: "Vi bruger de oplysninger, vi indsamler til:",
          items: [
            "At svare på dine henvendelser og give kundesupport",
            "At forbedre vores hjemmesides ydeevne og brugeroplevelse",
            "At spore besøgende interaktioner og klikmønstre for at forbedre vores tjenester",
            "At sikre overholdelse af Google Ads-politikker og danske spilregler",
            "At analysere hjemmesidetrafikmønstre gennem anonymiserede data",
          ],
        },
        dataProtection: {
          title: "Databeskyttelse",
          description: "Vi sælger aldrig brugerdata. Alle analyser er anonymiserede og baseret på samtykke for at forblive i overensstemmelse med Google Ads-politikker og GDPR-krav. Vi implementerer passende tekniske og organisatoriske foranstaltninger for at beskytte dine personlige oplysninger.",
        },
        cookies: {
          title: "Cookies og Sporing",
          description: "Vores hjemmeside bruger cookies og lignende sporingsteknologier til at analysere hjemmesidetrafik og forbedre brugeroplevelsen. Vi sporer besøgendes indgangsdata og klikinteraktioner for at forstå, hvordan brugere navigerer på vores side, og forbedre vores tjenester. Al sporing er anonymiseret og i overensstemmelse med Google Ads-politikker. Disse data hjælper os med at forbedre hjemmesidefunktionaliteten og brugeroplevelsen. Du kan kontrollere cookie-indstillinger gennem dine browserindstillinger.",
        },
        thirdParty: {
          title: "Tredjepartstjenester",
          description: "Vi kan bruge tredjepartstjenester til analyser og hjemmesidefunktionalitet. Disse tjenester er bundet af deres egne fortrolighedspolitikker og er valgt for deres engagement i databeskyttelse og overholdelse.",
        },
        yourRights: {
          title: "Dine Rettigheder",
          description: "Under GDPR har du ret til:",
          items: [
            "At få adgang til dine personlige data",
            "At anmode om rettelse af unøjagtige data",
            "At anmode om sletning af dine data",
            "At gøre indsigelse mod behandling af dine data",
            "Dataportabilitet",
          ],
          contactText: "For at udøve disse rettigheder, kontakt os på",
        },
        changes: {
          title: "Ændringer i Denne Politik",
          description: "Vi kan opdatere denne fortrolighedspolitik fra tid til anden. Vi vil underrette dig om eventuelle ændringer ved at offentliggøre den nye politik på denne side og opdatere \"Sidst opdateret\"-datoen.",
        },
        contact: {
          title: "Kontakt Os",
          description: "Hvis du har spørgsmål til denne fortrolighedspolitik, kontakt os på",
          lastUpdated: "Sidst opdateret:",
        },
      },
    },
    disclaimer: {
      title: "Vilkår og Betingelser",
      subtitle: "Vigtige oplysninger om vores bettingpartneranbefalinger og brugsvilkår.",
      badge: "Juridisk",
      sections: {
        general: {
          title: "Generelle Oplysninger",
          description: "{siteName} promoverer licenserede operatører, når det er muligt. Alle tilbud, bonusser og kampagner fra bettingpartnere kan ændres og er underlagt hver enkelt operatørs vilkår og betingelser. Vi stræber efter at give nøjagtige og opdaterede oplysninger, men vi kan ikke garantere tilgængeligheden eller vilkårene for noget tilbud.",
        },
        partnerOffers: {
          title: "Partnertilbud",
          description: "Alle velkomstbonusser, kampagner og tilbud vist på {siteName} er underlagt:",
          items: [
            "Vilkårene og betingelserne for den respektive bettingoperatør",
            "Kvalifikationskrav fastsat af hver operatør",
            "Tilgængelighed på tidspunktet for din registrering",
            "Geografiske begrænsninger og licenskrav",
          ],
          recommendation: "Vi anbefaler, at du gennemgår de fulde vilkår og betingelser på operatørens hjemmeside, før du gør krav på noget tilbud.",
        },
        licensing: {
          title: "Licensstatus",
          description: "{siteName} viser licensoplysninger for bettingpartnere, når de er tilgængelige. Vi gør alt for at verificere licensstatus, men operatører kan have licenser fra forskellige jurisdiktioner. Det er dit ansvar at verificere, at enhver operatør er licenseret og reguleret i din jurisdiktion, før du placerer væddemål.",
        },
        affiliate: {
          title: "Affiliate-forhold",
          description: "{siteName} opretholder affiliate-forhold med de bettingoperatører, der er vist på vores platform. Det betyder, at vi kan modtage kompensation, når brugere klikker og registrerer sig hos disse operatører. Dette påvirker ikke vores engagement i at give ærlige og gennemsigtige anbefalinger.",
        },
        noGuarantees: {
          title: "Ingen Garantier",
          description: "{siteName} garanterer ikke:",
          items: [
            "Tilgængeligheden af noget specifikt tilbud eller bonus",
            "Nøjagtigheden af bonusvilkår eller kampagnedetaljer",
            "Vindende resultater eller bettingresultater",
            "Ydeevnen eller pålideligheden af nogen bettingoperatør",
          ],
        },
        responsible: {
          title: "Ansvarligt Spil",
          description: "{siteName} er forpligtet til at fremme ansvarligt spil. Vi opfordrer alle brugere til:",
          items: [
            "At spille kun med penge, du har råd til at tabe",
            "At sætte grænser for dine spilaktiviteter",
            "At søge hjælp, hvis spil bliver et problem",
            "At gøre dig bekendt med ressourcer til ansvarligt spil",
          ],
          helpText: "Hvis du har brug for hjælp med spilproblemer, kontakt organisationer som StopSpillet, ROFUS eller dine lokale støttetjenester.",
        },
        ageRestrictions: {
          title: "Aldersbegrænsninger",
          description: "Alle bettingoperatører kræver, at brugere er mindst 18 år (eller den lovlige spillealder i din jurisdiktion). {siteName} promoverer ikke spil til mindreårige. Ved at bruge vores platform bekræfter du, at du opfylder de lovlige alderskrav for spil i din jurisdiktion.",
        },
        liability: {
          title: "Ansvarsbegrænsning",
          description: "{siteName} vil ikke være ansvarlig for eventuelle tab, skader eller problemer, der opstår fra:",
          items: [
            "Din brug af nogen bettingoperatørs tjenester",
            "Ændringer i tilbud, bonusser eller vilkår fra operatører",
            "Tvister mellem dig og bettingoperatører",
            "Tekniske problemer eller hjemmesideutilgængelighed",
          ],
        },
        contact: {
          title: "Kontakt Os",
          description: "Hvis du har spørgsmål til denne juridiske meddelelse, kontakt os på",
          lastUpdated: "Sidst opdateret:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Ofte Stillede Spørgsmål",
      subtitle: "Find svar på almindelige spørgsmål om vores platform og bettingpartneranbefalinger.",
      items: [
        {
          question: "Hvordan vælger I bettingpartnere?",
          answer: "Vi vurderer omhyggeligt alle bettingpartnere baseret på licensstatus, klarhed i bonustermer, brugeroplevelseskvalitet og overholdelse af Google Ads-politikker. Kun operatører, der opfylder vores strenge standarder, er vist på vores platform.",
        },
        {
          question: "Er alle partnere licenserede?",
          answer: "Vi prioriterer licenserede operatører og viser tydeligt licensoplysninger, når de er tilgængelige. Licensstatus kan dog variere efter jurisdiktion. Vi anbefaler at verificere, at enhver operatør er licenseret i din jurisdiktion, før du placerer væddemål.",
        },
        {
          question: "Modtager I kompensation fra partnere?",
          answer: "Ja, vi opretholder affiliate-forhold med de viste operatører. Det betyder, at vi kan modtage kompensation, når brugere klikker og registrerer sig gennem vores links. Dette påvirker ikke vores engagement i at give ærlige, gennemsigtige anbefalinger.",
        },
        {
          question: "Hvor ofte opdateres partnertilbud?",
          answer: "Vi gennemgår og opdaterer regelmæssigt partneroplysninger, bonusser og tilbud. Alle tilbud kan dog ændres af operatører, så vi anbefaler at tjekke operatørens hjemmeside for de mest aktuelle vilkår, før du gør krav på nogen bonus.",
        },
        {
          question: "Er mine personlige oplysninger sikre?",
          answer: "Ja, vi tager databeskyttelse alvorligt. Vi sælger aldrig brugerdata, og alle analyser er anonymiserede. Vi overholder GDPR-krav og Google Ads-politikker for at sikre, at dit privatliv er beskyttet.",
        },
        {
          question: "Kan jeg stole på jeres anbefalinger?",
          answer: "Absolut. Vores anbefalinger er baseret på grundig analyse af licensering, overholdelseshistorik, bonustermer og brugeroplevelse. Vi opretholder gennemsigtighed om affiliate-forhold og prioriterer dine bedste interesser.",
        },
      ],
    },
    positionLabels: [
      "Top Valg",
      "Redaktørens Valg",
      "Bedste Match",
      "Anbefalet",
      "God Mulighed",
      "Sjette Mulighed",
      "Syvende Mulighed",
      "Ottende Mulighed",
      "Niende Mulighed",
      "Tiende Mulighed",
      "Ellevte Mulighed",
    ],
  },
  fr: {
    hero: {
      badge: "Aperçus de Partenaires Vérifiés",
      tagline: "Plateformes de Paris UK les Mieux Notées",
      slidingText: [
        "Certifié et Protégé",
        "Sites de Retrait le Jour Même",
        "Documentation Minimale Requise",
        "Jeu Prioritaire à la Confidentialité",
      ],
    },
    features: {
      badge: "Plateforme de Confiance",
      title: "Pourquoi Faire Confiance à ReviewMasters?",
      subtitle: "Nous nous engageons à vous offrir la meilleure expérience de paris",
      ultraRapido: {
        title: "Ultra-rapide",
        description: "Optimisation des Core Web Vitals en LCP, CLS et FID. Notre plateforme se charge en moins de 2 secondes, garantissant un accès instantané aux meilleures opportunités de paris sans délais ni interruptions.",
      },
      conforme: {
        title: "Conforme",
        description: "Vérification manuelle des partenaires pour assurer la conformité aux politiques Google Ads. Chaque opérateur subit un examen rigoureux pour les licences, la clarté des conditions de bonus et l'adhésion réglementaire avant approbation.",
      },
      mobileFirst: {
        title: "Mobile d'abord",
        description: "Composants inspirés de Material qui convertissent sur n'importe quel appareil. Optimisé pour smartphones et tablettes avec un design responsive, garantissant des expériences de paris fluides que vous soyez à la maison ou en déplacement.",
      },
      transparente: {
        title: "Transparent",
        description: "Divulgation claire du statut de licence pour des choix responsables. Nous offrons une transparence totale sur les qualifications des opérateurs, les conditions de bonus et les relations d'affiliation afin que vous puissiez prendre des décisions éclairées en toute confiance.",
      },
    },
    partners: {
      heading: "Meilleures Offres de Paris UK 2025",
      claimNow: "Réclamer Maintenant",
      terms: "18+ Conditions applicables. Veuillez parier de manière responsable.",
      welcomeBonus: "Bonus de Bienvenue",
    },
    footer: {
      contact: "Contact",
      email: "Email:",
      phone: "Téléphone:",
      address: "Adresse:",
      compliance: "Conformité",
      quickLinks: "Liens Rapides",
      home: "Accueil",
      about: "À Propos",
      contactPage: "Contact",
      legal: "Légal",
      terms: "Termes et Conditions",
      privacy: "Politique de Confidentialité",
      responsibleGambling: "Jeu Responsable",
    },
    navigation: {
      home: "Accueil",
      about: "À Propos",
      contact: "Contact",
    },
    about: {
      badge: "À Propos de Nous",
      title: "À Propos de {siteName}",
      subtitle: "{siteName} existe pour connecter les parieurs UK avec des offres transparentes et promues de manière responsable par des maisons de paris et des bookmakers. Notre équipe analyse l'historique de conformité, les conditions de bonus et l'UX mobile de chaque opérateur pour garantir que vous puissiez exécuter des campagnes Google Ads en toute confiance.",
      mission: {
        title: "Notre Mission",
        description: "Défendre le jeu sûr et responsable tout en aidant les partenaires à créer des parcours d'acquisition de classe mondiale.",
      },
      compliance: {
        title: "Conformité d'Abord",
        description: "Nous auditons les créatifs et les pages de destination selon les directives UKGC et les politiques Google Ads avant leur approbation.",
      },
      dataDriven: {
        title: "Tests Basés sur les Données",
        description: "Tableaux de bord de performance et données de conversion (liées au gclid) alimentent les examens hebdomadaires des partenaires.",
      },
      commitment: {
        title: "Notre Engagement",
        description: "Nous nous engageons à créer une plateforme de confiance qui connecte les parieurs UK aux meilleures opportunités de paris, en maintenant les plus hauts standards de conformité et de transparence.",
      },
      trust: {
        title: "Confiance et Transparence",
        description: "Chaque partenaire est soigneusement vérifié pour les licences, la clarté des conditions de bonus et la qualité de l'expérience utilisateur. Nous croyons en une transparence totale sur le statut des opérateurs et les détails des offres.",
      },
      performance: {
        title: "Excellence de Performance",
        description: "Notre plateforme est optimisée pour la vitesse, la réactivité mobile et la conversion. Nous suivons les métriques de performance pour améliorer continuellement l'expérience des partenaires de paris.",
      },
    },
    contact: {
      badge: "Entrer en Contact",
      title: "Collaborons ensemble",
      subtitle: "Partagez vos objectifs de campagne et nous recommanderons le meilleur positionnement de partenaire, bonus et plan de suivi.",
      formTitle: "Envoyez-nous un message",
      formDescription: "Remplissez le formulaire ci-dessous et nous vous répondrons dans les 24 heures.",
      contactDetails: "Détails de Contact",
      email: "Email",
      phone: "Téléphone",
      address: "Adresse",
    },
    privacy: {
      title: "Politique de Confidentialité",
      subtitle: "Votre confidentialité est importante pour nous. Cette politique explique comment nous collectons, utilisons et protégeons vos informations.",
      badge: "Légal",
      sections: {
        informationWeCollect: {
          title: "Informations que Nous Collectons",
          description: "{siteName} collecte des informations minimales nécessaires pour fournir nos services. Nous pouvons collecter:",
          items: [
            "Informations de contact lorsque vous soumettez un formulaire (nom, adresse email)",
            "Données d'utilisation via des analyses anonymisées pour améliorer notre site web",
            "Données de suivi des visiteurs (URLs d'entrée, informations de référent, horodatages) pour comprendre le comportement des utilisateurs",
            "Données de suivi des clics pour analyser quels liens de partenaires sont cliqués et améliorer nos services",
            "Informations techniques telles que l'adresse IP, le type de navigateur et les informations sur l'appareil",
          ],
        },
        howWeUse: {
          title: "Comment Nous Utilisons Vos Informations",
          description: "Nous utilisons les informations que nous collectons pour:",
          items: [
            "Répondre à vos demandes et fournir un support client",
            "Améliorer les performances de notre site web et l'expérience utilisateur",
            "Suivre les interactions des visiteurs et les modèles de clics pour améliorer nos services",
            "Assurer la conformité aux politiques Google Ads et aux réglementations de jeu UK",
            "Analyser les modèles de trafic du site web via des données anonymisées",
          ],
        },
        dataProtection: {
          title: "Protection des Données",
          description: "Nous ne vendons jamais les données utilisateur. Toutes les analyses sont anonymisées et basées sur le consentement pour rester conformes aux politiques Google Ads et aux exigences GDPR. Nous mettons en place des mesures techniques et organisationnelles appropriées pour protéger vos informations personnelles.",
        },
        cookies: {
          title: "Cookies et Suivi",
          description: "Notre site web utilise des cookies et des technologies de suivi similaires pour analyser le trafic du site web et améliorer l'expérience utilisateur. Nous suivons les données d'entrée des visiteurs et les interactions de clics pour comprendre comment les utilisateurs naviguent sur notre site et améliorer nos services. Tout le suivi est anonymisé et conforme aux politiques Google Ads. Ces données nous aident à améliorer la fonctionnalité du site web et l'expérience utilisateur. Vous pouvez contrôler les préférences de cookies via les paramètres de votre navigateur.",
        },
        thirdParty: {
          title: "Services Tiers",
          description: "Nous pouvons utiliser des services tiers pour les analyses et la fonctionnalité du site web. Ces services sont liés par leurs propres politiques de confidentialité et sont sélectionnés pour leur engagement envers la protection des données et la conformité.",
        },
        yourRights: {
          title: "Vos Droits",
          description: "Sous GDPR, vous avez le droit de:",
          items: [
            "Accéder à vos données personnelles",
            "Demander la correction de données inexactes",
            "Demander la suppression de vos données",
            "Vous opposer au traitement de vos données",
            "Portabilité des données",
          ],
          contactText: "Pour exercer ces droits, contactez-nous à",
        },
        changes: {
          title: "Modifications de Cette Politique",
          description: "Nous pouvons mettre à jour cette politique de confidentialité de temps à autre. Nous vous informerons de tout changement en publiant la nouvelle politique sur cette page et en mettant à jour la date de \"Dernière mise à jour\".",
        },
        contact: {
          title: "Contactez-Nous",
          description: "Si vous avez des questions sur cette politique de confidentialité, contactez-nous à",
          lastUpdated: "Dernière mise à jour:",
        },
      },
    },
    disclaimer: {
      title: "Termes et Conditions",
      subtitle: "Informations importantes sur nos recommandations de partenaires de paris et conditions d'utilisation.",
      badge: "Légal",
      sections: {
        general: {
          title: "Informations Générales",
          description: "{siteName} promeut les opérateurs licenciés chaque fois que possible. Toutes les offres, bonus et promotions des partenaires de paris sont sujettes à modification et sont régies par les termes et conditions de chaque opérateur individuel. Nous nous efforçons de fournir des informations précises et à jour, mais nous ne pouvons garantir la disponibilité ou les conditions de toute offre.",
        },
        partnerOffers: {
          title: "Offres de Partenaires",
          description: "Tous les bonus de bienvenue, promotions et offres affichés sur {siteName} sont soumis à:",
          items: [
            "Les termes et conditions de l'opérateur de paris respectif",
            "Les exigences d'éligibilité établies par chaque opérateur",
            "La disponibilité au moment de votre inscription",
            "Les restrictions géographiques et les exigences de licence",
          ],
          recommendation: "Nous recommandons que vous examiniez les termes et conditions complets sur le site web de l'opérateur avant de réclamer toute offre.",
        },
        licensing: {
          title: "Statut de Licence",
          description: "{siteName} affiche les informations de licence pour les partenaires de paris lorsqu'elles sont disponibles. Nous faisons tous les efforts pour vérifier le statut de licence, mais les opérateurs peuvent détenir des licences de différentes juridictions. Il est de votre responsabilité de vérifier que tout opérateur est licencié et réglementé dans votre juridiction avant de placer des paris.",
        },
        affiliate: {
          title: "Relations d'Affiliation",
          description: "{siteName} entretient des relations d'affiliation avec les opérateurs de paris présentés sur notre plateforme. Cela signifie que nous pouvons recevoir une compensation lorsque les utilisateurs cliquent et s'inscrivent auprès de ces opérateurs. Cela n'affecte pas notre engagement à fournir des recommandations honnêtes et transparentes.",
        },
        noGuarantees: {
          title: "Aucune Garantie",
          description: "{siteName} ne garantit pas:",
          items: [
            "La disponibilité de toute offre ou bonus spécifique",
            "L'exactitude des informations de bonus ou de promotion",
            "Les résultats de toute transaction avec un opérateur",
            "La disponibilité continue de tout opérateur sur notre plateforme",
          ],
        },
        responsible: {
          title: "Jeu Responsable",
          description: "Le jeu peut être addictif. {siteName} s'engage à promouvoir le jeu responsable. Nous recommandons fortement:",
          items: [
            "Ne jamais parier plus que vous ne pouvez vous permettre de perdre",
            "Fixer des limites de temps et d'argent avant de commencer",
            "Ne jamais jouer sous l'influence de l'alcool ou de drogues",
            "Chercher de l'aide si vous pensez avoir un problème de jeu",
          ],
          helpText: "Si vous avez besoin d'aide avec le jeu problématique, contactez BeGambleAware ou GamCare pour obtenir du soutien et des ressources.",
        },
        ageRestrictions: {
          title: "Restrictions d'Âge",
          description: "Tous les opérateurs présentés sur {siteName} exigent que les utilisateurs aient au moins 18 ans pour s'inscrire et placer des paris. Il est de votre responsabilité de vous assurer que vous respectez les exigences d'âge légales dans votre juridiction.",
        },
        liability: {
          title: "Limitation de Responsabilité",
          description: "{siteName} n'est pas responsable de:",
          items: [
            "Toute perte financière résultant de l'utilisation de nos recommandations",
            "Les actions ou omissions de tout opérateur de paris",
            "Les changements dans les conditions de bonus ou les offres",
            "Tout problème technique rencontré lors de l'accès aux sites d'opérateurs",
          ],
        },
        contact: {
          title: "Contactez-Nous",
          description: "Si vous avez des questions sur ces termes et conditions, contactez-nous à",
          lastUpdated: "Dernière mise à jour:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Questions Fréquemment Posées",
      subtitle: "Trouvez des réponses aux questions courantes sur nos services et nos partenaires de paris.",
      items: [
        {
          question: "Comment sélectionnez-vous vos partenaires de paris?",
          answer: "Nous effectuons une vérification manuelle approfondie de chaque opérateur, en examinant l'historique de conformité, la clarté des conditions de bonus, l'expérience utilisateur mobile et l'adhésion réglementaire. Seuls les opérateurs qui répondent à nos normes strictes sont approuvés.",
        },
        {
          question: "Les bonus sont-ils garantis?",
          answer: "Non, nous ne pouvons pas garantir la disponibilité des bonus. Tous les bonus et offres sont sujets à modification et sont régis par les termes et conditions de chaque opérateur. Nous recommandons de vérifier le site web de l'opérateur pour les conditions les plus récentes avant de réclamer un bonus.",
        },
        {
          question: "Comment fonctionne le suivi des clics?",
          answer: "Nous utilisons des paramètres de suivi (comme gclid) pour analyser quels liens de partenaires sont cliqués. Ces données sont anonymisées et utilisées uniquement pour améliorer nos services et comprendre le comportement des utilisateurs. Ces informations ne sont jamais vendues ou partagées avec des tiers.",
        },
        {
          question: "Recevez-vous une compensation des partenaires?",
          answer: "Oui, nous entretenons des relations d'affiliation avec les opérateurs présentés. Cela signifie que nous pouvons recevoir une compensation lorsque les utilisateurs cliquent et s'inscrivent via nos liens. Cela n'affecte pas notre engagement à fournir des recommandations honnêtes et transparentes.",
        },
        {
          question: "À quelle fréquence les offres de partenaires sont-elles mises à jour?",
          answer: "Nous examinons et mettons à jour régulièrement les informations, bonus et offres des partenaires. Cependant, toutes les offres peuvent être modifiées par les opérateurs, nous recommandons donc de vérifier le site web de l'opérateur pour les conditions les plus récentes avant de réclamer un bonus.",
        },
        {
          question: "Mes informations personnelles sont-elles sécurisées?",
          answer: "Oui, nous prenons la protection des données au sérieux. Nous ne vendons jamais les données utilisateur et toutes les analyses sont anonymisées. Nous respectons les exigences GDPR et les politiques Google Ads pour garantir que votre vie privée est protégée.",
        },
        {
          question: "Puis-je faire confiance à vos recommandations?",
          answer: "Absolument. Nos recommandations sont basées sur une analyse approfondie de la licence, de l'historique de conformité, des conditions de bonus et de l'expérience utilisateur. Nous maintenons la transparence sur les relations d'affiliation et priorisons vos meilleurs intérêts.",
        },
      ],
    },
    positionLabels: [
      "Top Choix",
      "Choix de l'Éditeur",
      "Meilleur Match",
      "Recommandé",
      "Bonne Opportunité",
      "Sixième Opportunité",
      "Septième Opportunité",
      "Huitième Opportunité",
      "Neuvième Opportunité",
      "Dixième Opportunité",
      "Onzième Opportunité",
    ],
  },
  nl: {
    hero: {
      badge: "Geverifieerde Partner Inzichten",
      tagline: "Beste UK Goksites",
      slidingText: [
        "Gecertificeerd & Beschermd",
        "Sites met Opname op dezelfde Dag",
        "Minimale Documentatie Vereist",
        "Privacy-Eerst Gaming",
      ],
    },
    features: {
      badge: "Vertrouwd Platform",
      title: "Waarom ReviewMasters Vertrouwen?",
      subtitle: "We zijn toegewijd aan het bieden van de beste gokervaring",
      ultraRapido: {
        title: "Ultra-snel",
        description: "Core Web Vitals optimalisatie in LCP, CLS en FID. Ons platform laadt in minder dan 2 seconden, waardoor directe toegang tot de beste gokkansen zonder vertragingen of onderbrekingen wordt gegarandeerd.",
      },
      conforme: {
        title: "Conform",
        description: "Handmatige verificatie van partners om naleving van Google Ads-beleid te waarborgen. Elke operator ondergaat een rigoureuze screening voor licentie, duidelijkheid van bonustermen en regelgevingsnaleving voordat goedkeuring wordt verleend.",
      },
      mobileFirst: {
        title: "Mobile-first",
        description: "Material-geïnspireerde componenten die converteren op elk apparaat. Geoptimaliseerd voor smartphones en tablets met responsive design, waardoor naadloze gokervaringen worden gegarandeerd, of u nu thuis bent of onderweg.",
      },
      transparente: {
        title: "Transparant",
        description: "Duidelijke openbaarmaking van licentiestatus voor verantwoorde keuzes. We bieden volledige transparantie over operatorreferenties, bonustermen en affiliate-relaties, zodat u met vertrouwen weloverwogen beslissingen kunt nemen.",
      },
    },
    partners: {
      heading: "Top UK Gokaanbiedingen 2025",
      claimNow: "Claim Nu",
      terms: "18+ Voorwaarden zijn van toepassing. Speel verantwoord.",
      welcomeBonus: "Welkomstbonus",
    },
    footer: {
      contact: "Contact",
      email: "Email:",
      phone: "Telefoon:",
      address: "Adres:",
      compliance: "Naleving",
      quickLinks: "Snelle Links",
      home: "Home",
      about: "Over Ons",
      contactPage: "Contact",
      legal: "Juridisch",
      terms: "Algemene Voorwaarden",
      privacy: "Privacybeleid",
      responsibleGambling: "Verantwoord Gokken",
    },
    navigation: {
      home: "Home",
      about: "Over",
      contact: "Contact",
    },
    about: {
      badge: "Over Ons",
      title: "Over {siteName}",
      subtitle: "{siteName} bestaat om UK gokkers te verbinden met transparante en verantwoord gepromote aanbiedingen van gokhuizen en bookmakers. Ons team analyseert de nalevingsgeschiedenis, bonustermen en mobiele UX van elke operator om ervoor te zorgen dat u Google Ads-campagnes met vertrouwen kunt uitvoeren.",
      mission: {
        title: "Onze Missie",
        description: "Pleiten voor veilig en verantwoord gokken terwijl we partners helpen wereldklasse acquisitietrajecten te creëren.",
      },
      compliance: {
        title: "Naleving Eerst",
        description: "We auditen creatieven en landingspagina's tegen UKGC-richtlijnen en Google Ads-beleid voordat ze worden goedgekeurd.",
      },
      dataDriven: {
        title: "Data-Gedreven Testen",
        description: "Prestatiedashboards en conversiedata (gekoppeld aan gclid) voeden wekelijkse partnerbeoordelingen.",
      },
      commitment: {
        title: "Onze Toewijding",
        description: "We zijn toegewijd aan het creëren van een vertrouwd platform dat UK gokkers verbindt met de beste gokkansen, met behoud van de hoogste normen voor naleving en transparantie.",
      },
      trust: {
        title: "Vertrouwen & Transparantie",
        description: "Elke partner wordt zorgvuldig geverifieerd op licentie, duidelijkheid van bonustermen en gebruikerservaring. We geloven in volledige transparantie over operatorstatus en aanbiedingsdetails.",
      },
      performance: {
        title: "Prestatie-Excellentie",
        description: "Ons platform is geoptimaliseerd voor snelheid, mobiele responsiviteit en conversie. We volgen prestatiemetrieken om continu de gokpartnerervaring te verbeteren.",
      },
    },
    contact: {
      badge: "Neem Contact Op",
      title: "Laten we samenwerken",
      subtitle: "Deel uw campagne doelen en we zullen de beste partnerpositionering, bonus en trackingplan aanbevelen.",
      formTitle: "Stuur ons een bericht",
      formDescription: "Vul het onderstaande formulier in en we nemen binnen 24 uur contact met u op.",
      contactDetails: "Contactgegevens",
      email: "Email",
      phone: "Telefoon",
      address: "Adres",
    },
    privacy: {
      title: "Privacybeleid",
      subtitle: "Uw privacy is belangrijk voor ons. Dit beleid legt uit hoe we uw informatie verzamelen, gebruiken en beschermen.",
      badge: "Juridisch",
      sections: {
        informationWeCollect: {
          title: "Informatie die We Verzamelen",
          description: "{siteName} verzamelt minimale informatie die nodig is om onze diensten te leveren. We kunnen verzamelen:",
          items: [
            "Contactgegevens wanneer u een formulier indient (naam, e-mailadres)",
            "Gebruiksgegevens via geanonimiseerde analyses om onze website te verbeteren",
            "Bezoekers trackinggegevens (ingangs-URL's, referer-informatie, tijdstempels) om gebruikersgedrag te begrijpen",
            "Klik trackinggegevens om te analyseren welke partnerlinks worden aangeklikt en onze diensten te verbeteren",
            "Technische informatie zoals IP-adres, browsertype en apparaatinformatie",
          ],
        },
        howWeUse: {
          title: "Hoe We Uw Informatie Gebruiken",
          description: "We gebruiken de informatie die we verzamelen om:",
          items: [
            "Te reageren op uw vragen en klantenservice te bieden",
            "Onze websiteprestaties en gebruikerservaring te verbeteren",
            "Bezoekersinteracties en klikpatronen bij te houden om onze diensten te verbeteren",
            "Naleving van Google Ads-beleid en UK gokregelgeving te waarborgen",
            "Websiteverkeerspatronen te analyseren via geanonimiseerde gegevens",
          ],
        },
        dataProtection: {
          title: "Gegevensbescherming",
          description: "We verkopen nooit gebruikersgegevens. Alle analyses zijn geanonimiseerd en op basis van toestemming om conform te blijven aan Google Ads-beleid en GDPR-vereisten. We implementeren passende technische en organisatorische maatregelen om uw persoonlijke informatie te beschermen.",
        },
        cookies: {
          title: "Cookies en Tracking",
          description: "Onze website gebruikt cookies en vergelijkbare trackingtechnologieën om websiteverkeer te analyseren en gebruikerservaring te verbeteren. We volgen bezoekersingangsgegevens en klikinteracties om te begrijpen hoe gebruikers op onze site navigeren en onze diensten te verbeteren. Alle tracking is geanonimiseerd en conform Google Ads-beleid. Deze gegevens helpen ons de websitefunctionaliteit en gebruikerservaring te verbeteren. U kunt cookievoorkeuren beheren via uw browserinstellingen.",
        },
        thirdParty: {
          title: "Derde Partij Diensten",
          description: "We kunnen diensten van derden gebruiken voor analyses en websitefunctionaliteit. Deze diensten zijn gebonden aan hun eigen privacybeleid en worden geselecteerd vanwege hun toewijding aan gegevensbescherming en naleving.",
        },
        yourRights: {
          title: "Uw Rechten",
          description: "Onder GDPR heeft u het recht om:",
          items: [
            "Toegang te krijgen tot uw persoonlijke gegevens",
            "Correctie van onjuiste gegevens aan te vragen",
            "Verwijdering van uw gegevens aan te vragen",
            "Bezwaar te maken tegen verwerking van uw gegevens",
            "Gegevensportabiliteit",
          ],
          contactText: "Om deze rechten uit te oefenen, neem contact met ons op via",
        },
        changes: {
          title: "Wijzigingen in Dit Beleid",
          description: "We kunnen dit privacybeleid van tijd tot tijd bijwerken. We zullen u op de hoogte stellen van eventuele wijzigingen door het nieuwe beleid op deze pagina te plaatsen en de datum \"Laatst bijgewerkt\" bij te werken.",
        },
        contact: {
          title: "Neem Contact Op",
          description: "Als u vragen heeft over dit privacybeleid, neem contact met ons op via",
          lastUpdated: "Laatst bijgewerkt:",
        },
      },
    },
    disclaimer: {
      title: "Algemene Voorwaarden",
      subtitle: "Belangrijke informatie over onze gokpartneraanbevelingen en gebruiksvoorwaarden.",
      badge: "Juridisch",
      sections: {
        general: {
          title: "Algemene Informatie",
          description: "{siteName} promoot gelicentieerde operators waar mogelijk. Alle aanbiedingen, bonussen en promoties van gokpartners zijn onderhevig aan wijzigingen en worden beheerst door de algemene voorwaarden van elke individuele operator. We streven ernaar accurate en actuele informatie te verstrekken, maar we kunnen de beschikbaarheid of voorwaarden van enige aanbieding niet garanderen.",
        },
        partnerOffers: {
          title: "Partneraanbiedingen",
          description: "Alle welkomstbonussen, promoties en aanbiedingen die op {siteName} worden weergegeven, zijn onderhevig aan:",
          items: [
            "De algemene voorwaarden van de respectieve gokoperator",
            "Eligibiliteitsvereisten vastgesteld door elke operator",
            "Beschikbaarheid op het moment van uw registratie",
            "Geografische beperkingen en licentievereisten",
          ],
          recommendation: "We raden aan dat u de volledige algemene voorwaarden op de website van de operator bekijkt voordat u een aanbieding claimt.",
        },
        licensing: {
          title: "Licentiestatus",
          description: "{siteName} toont licentie-informatie voor gokpartners wanneer beschikbaar. We doen ons best om licentiestatus te verifiëren, maar operators kunnen licenties hebben van verschillende jurisdicties. Het is uw verantwoordelijkheid om te verifiëren dat een operator is gelicentieerd en gereguleerd in uw jurisdictie voordat u weddenschappen plaatst.",
        },
        affiliate: {
          title: "Affiliate Relaties",
          description: "{siteName} onderhoudt affiliate-relaties met de gokoperators die op ons platform worden getoond. Dit betekent dat we compensatie kunnen ontvangen wanneer gebruikers klikken en zich registreren bij deze operators. Dit heeft geen invloed op onze toewijding aan het verstrekken van eerlijke en transparante aanbevelingen.",
        },
        noGuarantees: {
          title: "Geen Garanties",
          description: "{siteName} garandeert niet:",
          items: [
            "De beschikbaarheid van enige specifieke aanbieding of bonus",
            "De nauwkeurigheid van bonus- of promotie-informatie",
            "De resultaten van enige transactie met een operator",
            "De continue beschikbaarheid van enige operator op ons platform",
          ],
        },
        responsible: {
          title: "Verantwoord Gokken",
          description: "Gokken kan verslavend zijn. {siteName} is toegewijd aan het promoten van verantwoord gokken. We raden sterk aan:",
          items: [
            "Nooit meer te gokken dan u zich kunt veroorloven te verliezen",
            "Tijd- en geldlimieten in te stellen voordat u begint",
            "Nooit te spelen onder invloed van alcohol of drugs",
            "Hulp te zoeken als u denkt dat u een gokprobleem heeft",
          ],
          helpText: "Als u hulp nodig heeft met problematisch gokken, neem contact op met BeGambleAware of GamCare voor ondersteuning en middelen.",
        },
        ageRestrictions: {
          title: "Leeftijdsbeperkingen",
          description: "Alle operators die op {siteName} worden getoond, vereisen dat gebruikers minimaal 18 jaar oud zijn om zich te registreren en weddenschappen te plaatsen. Het is uw verantwoordelijkheid om ervoor te zorgen dat u voldoet aan de wettelijke leeftijdsvereisten in uw jurisdictie.",
        },
        liability: {
          title: "Aansprakelijkheidsbeperking",
          description: "{siteName} is niet aansprakelijk voor:",
          items: [
            "Enig financieel verlies als gevolg van het gebruik van onze aanbevelingen",
            "Handelingen of nalatigheden van enige gokoperator",
            "Wijzigingen in bonustermen of aanbiedingen",
            "Enig technisch probleem dat optreedt bij toegang tot operatorsites",
          ],
        },
        contact: {
          title: "Neem Contact Op",
          description: "Als u vragen heeft over deze algemene voorwaarden, neem contact met ons op via",
          lastUpdated: "Laatst bijgewerkt:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Veelgestelde Vragen",
      subtitle: "Vind antwoorden op veelgestelde vragen over onze diensten en gokpartners.",
      items: [
        {
          question: "Hoe selecteert u uw gokpartners?",
          answer: "We voeren een grondige handmatige verificatie uit van elke operator, waarbij we de nalevingsgeschiedenis, duidelijkheid van bonustermen, mobiele gebruikerservaring en regelgevingsnaleving onderzoeken. Alleen operators die voldoen aan onze strikte normen worden goedgekeurd.",
        },
        {
          question: "Zijn bonussen gegarandeerd?",
          answer: "Nee, we kunnen de beschikbaarheid van bonussen niet garanderen. Alle bonussen en aanbiedingen zijn onderhevig aan wijzigingen en worden beheerst door de algemene voorwaarden van elke operator. We raden aan om de website van de operator te controleren op de nieuwste voorwaarden voordat u een bonus claimt.",
        },
        {
          question: "Hoe werkt kliktracking?",
          answer: "We gebruiken trackingparameters (zoals gclid) om te analyseren welke partnerlinks worden aangeklikt. Deze gegevens zijn geanonimiseerd en worden alleen gebruikt om onze diensten te verbeteren en gebruikersgedrag te begrijpen. Deze informatie wordt nooit verkocht of gedeeld met derden.",
        },
        {
          question: "Ontvangt u compensatie van partners?",
          answer: "Ja, we onderhouden affiliate-relaties met de getoonde operators. Dit betekent dat we compensatie kunnen ontvangen wanneer gebruikers klikken en zich registreren via onze links. Dit heeft geen invloed op onze toewijding aan het verstrekken van eerlijke en transparante aanbevelingen.",
        },
        {
          question: "Hoe vaak worden partneraanbiedingen bijgewerkt?",
          answer: "We beoordelen en updaten regelmatig partnerinformatie, bonussen en aanbiedingen. Alle aanbiedingen kunnen echter door operators worden gewijzigd, dus we raden aan om de website van de operator te controleren op de nieuwste voorwaarden voordat u een bonus claimt.",
        },
        {
          question: "Zijn mijn persoonlijke gegevens veilig?",
          answer: "Ja, we nemen gegevensbescherming serieus. We verkopen nooit gebruikersgegevens en alle analyses zijn geanonimiseerd. We voldoen aan GDPR-vereisten en Google Ads-beleid om ervoor te zorgen dat uw privacy wordt beschermd.",
        },
        {
          question: "Kan ik uw aanbevelingen vertrouwen?",
          answer: "Absoluut. Onze aanbevelingen zijn gebaseerd op grondige analyse van licentie, nalevingsgeschiedenis, bonustermen en gebruikerservaring. We handhaven transparantie over affiliate-relaties en prioriteren uw beste belangen.",
        },
      ],
    },
    positionLabels: [
      "Top Keuze",
      "Redactie Keuze",
      "Beste Match",
      "Aanbevolen",
      "Goede Kans",
      "Zesde Kans",
      "Zevende Kans",
      "Achtste Kans",
      "Negende Kans",
      "Tiende Kans",
      "Elfde Kans",
    ],
  },
  sv: {
    hero: {
      badge: "Verifierade Partnerinsikter",
      tagline: "Bästa UK Spelsidor",
      slidingText: [
        "Certifierad & Skyddad",
        "Sidor med Uttag Samma Dag",
        "Minimal Dokumentation Krävs",
        "Integritet-Först Spel",
      ],
    },
    features: {
      badge: "Pålitlig Plattform",
      title: "Varför Lita på ReviewMasters?",
      subtitle: "Vi är dedikerade till att ge dig den bästa spelupplevelsen",
      ultraRapido: {
        title: "Ultra-snabb",
        description: "Core Web Vitals-optimering i LCP, CLS och FID. Vår plattform laddas på mindre än 2 sekunder, vilket säkerställer omedelbar åtkomst till de bästa spelmöjligheterna utan fördröjningar eller avbrott.",
      },
      conforme: {
        title: "Efterlevnad",
        description: "Manuell verifiering av partners för att säkerställa efterlevnad av Google Ads-policyer. Varje operatör genomgår rigorös screening för licens, tydlighet i bonusvillkor och regelverksföljande innan godkännande.",
      },
      mobileFirst: {
        title: "Mobil-först",
        description: "Material-inspirerade komponenter som konverterar på vilken enhet som helst. Optimerad för smartphones och surfplattor med responsiv design, vilket säkerställer sömlösa spelupplevelser oavsett om du är hemma eller på språng.",
      },
      transparente: {
        title: "Transparent",
        description: "Tydlig redovisning av licensstatus för ansvarsfulla val. Vi ger full transparens om operatörsreferenser, bonusvillkor och affiliate-relationer så att du kan fatta välgrundade beslut med självförtroende.",
      },
    },
    partners: {
      heading: "Topp UK Spelerbjudanden 2025",
      claimNow: "Gör Anspråk Nu",
      terms: "18+ Villkor gäller. Spela ansvarsfullt.",
      welcomeBonus: "Välkomstbonus",
    },
    footer: {
      contact: "Kontakt",
      email: "E-post:",
      phone: "Telefon:",
      address: "Adress:",
      compliance: "Efterlevnad",
      quickLinks: "Snabblänkar",
      home: "Hem",
      about: "Om Oss",
      contactPage: "Kontakt",
      legal: "Juridisk",
      terms: "Villkor",
      privacy: "Integritetspolicy",
      responsibleGambling: "Ansvarsfullt Spelande",
    },
    navigation: {
      home: "Hem",
      about: "Om",
      contact: "Kontakt",
    },
    about: {
      badge: "Om Oss",
      title: "Om {siteName}",
      subtitle: "{siteName} finns för att koppla UK-spelare med transparenta och ansvarsfullt marknadsförda erbjudanden från spelhus och bookmakers. Vårt team analyserar varje operatörs efterlevnadshistorik, bonusvillkor och mobil UX för att säkerställa att du kan köra Google Ads-kampanjer med självförtroende.",
      mission: {
        title: "Vårt Uppdrag",
        description: "Förespråka säkert och ansvarsfullt spelande samtidigt som vi hjälper partners att skapa världsklassiga förvärvsresor.",
      },
      compliance: {
        title: "Efterlevnad Först",
        description: "Vi granskar kreativa och landningssidor mot UKGC-riktlinjer och Google Ads-policyer innan de godkänns.",
      },
      dataDriven: {
        title: "Data-Driven Testning",
        description: "Prestandainstrumentpaneler och konverteringsdata (länkade till gclid) driver veckovisa partnerrecensioner.",
      },
      commitment: {
        title: "Vårt Åtagande",
        description: "Vi är dedikerade till att skapa en pålitlig plattform som kopplar UK-spelare med de bästa spelmöjligheterna, med bibehållande av de högsta standarderna för efterlevnad och transparens.",
      },
      trust: {
        title: "Förtroende & Transparens",
        description: "Varje partner verifieras noggrant för licens, tydlighet i bonusvillkor och användarupplevelsekvalitet. Vi tror på full transparens om operatörsstatus och erbjudandedetaljer.",
      },
      performance: {
        title: "Prestanda-Excellens",
        description: "Vår plattform är optimerad för hastighet, mobil responsivitet och konvertering. Vi spårar prestandamätvärden för att kontinuerligt förbättra spelpartnerupplevelsen.",
      },
    },
    contact: {
      badge: "Kontakta Oss",
      title: "Låt oss samarbeta",
      subtitle: "Dela dina kampanjmål och vi kommer att rekommendera den bästa partnerpositioneringen, bonusen och spårningsplanen.",
      formTitle: "Skicka oss ett meddelande",
      formDescription: "Fyll i formuläret nedan så återkommer vi inom 24 timmar.",
      contactDetails: "Kontaktuppgifter",
      email: "E-post",
      phone: "Telefon",
      address: "Adress",
    },
    privacy: {
      title: "Integritetspolicy",
      subtitle: "Din integritet är viktig för oss. Denna policy förklarar hur vi samlar in, använder och skyddar din information.",
      badge: "Juridisk",
      sections: {
        informationWeCollect: {
          title: "Information Vi Samlar In",
          description: "{siteName} samlar in minimal information som behövs för att tillhandahålla våra tjänster. Vi kan samla in:",
          items: [
            "Kontaktinformation när du skickar in ett formulär (namn, e-postadress)",
            "Användningsdata via anonymiserade analyser för att förbättra vår webbplats",
            "Besökarspårningsdata (ingångs-URL:er, referer-information, tidsstämplar) för att förstå användar beteende",
            "Klickspårningsdata för att analysera vilka partnerlänkar som klickas på och förbättra våra tjänster",
            "Teknisk information såsom IP-adress, webbläsartyp och enhetsinformation",
          ],
        },
        howWeUse: {
          title: "Hur Vi Använder Din Information",
          description: "Vi använder informationen vi samlar in för att:",
          items: [
            "Svara på dina förfrågningar och ge kundsupport",
            "Förbättra vår webbplatsprestanda och användarupplevelse",
            "Spåra besökarinteraktioner och klickmönster för att förbättra våra tjänster",
            "Säkerställa efterlevnad av Google Ads-policyer och UK-spelregler",
            "Analysera webbplatstrafikmönster via anonymiserade data",
          ],
        },
        dataProtection: {
          title: "Dataskydd",
          description: "Vi säljer aldrig användardata. Alla analyser är anonymiserade och baserade på samtycke för att förbli kompatibla med Google Ads-policyer och GDPR-krav. Vi implementerar lämpliga tekniska och organisatoriska åtgärder för att skydda din personliga information.",
        },
        cookies: {
          title: "Cookies och Spårning",
          description: "Vår webbplats använder cookies och liknande spårningsteknologier för att analysera webbplatstrafik och förbättra användarupplevelsen. Vi spårar besökar ingångsdata och klickinteraktioner för att förstå hur användare navigerar på vår webbplats och förbättra våra tjänster. All spårning är anonymiserad och kompatibel med Google Ads-policyer. Dessa data hjälper oss att förbättra webbplatsfunktionalitet och användarupplevelse. Du kan kontrollera cookie-inställningar via dina webbläsarinställningar.",
        },
        thirdParty: {
          title: "Tredjepartstjänster",
          description: "Vi kan använda tredjepartstjänster för analyser och webbplatsfunktionalitet. Dessa tjänster är bundna av sina egna integritetspolicyer och väljs för sitt engagemang för dataskydd och efterlevnad.",
        },
        yourRights: {
          title: "Dina Rättigheter",
          description: "Enligt GDPR har du rätt att:",
          items: [
            "Få tillgång till dina personuppgifter",
            "Begära korrigering av felaktiga data",
            "Begära radering av dina data",
            "Invända mot behandling av dina data",
            "Dataportabilitet",
          ],
          contactText: "För att utöva dessa rättigheter, kontakta oss på",
        },
        changes: {
          title: "Ändringar i Denna Policy",
          description: "Vi kan uppdatera denna integritetspolicy från tid till annan. Vi kommer att meddela dig om eventuella ändringar genom att publicera den nya policyn på denna sida och uppdatera datumet \"Senast uppdaterad\".",
        },
        contact: {
          title: "Kontakta Oss",
          description: "Om du har frågor om denna integritetspolicy, kontakta oss på",
          lastUpdated: "Senast uppdaterad:",
        },
      },
    },
    disclaimer: {
      title: "Villkor",
      subtitle: "Viktig information om våra spelpartnerrekommendationer och användarvillkor.",
      badge: "Juridisk",
      sections: {
        general: {
          title: "Allmän Information",
          description: "{siteName} marknadsför licensierade operatörer när det är möjligt. Alla erbjudanden, bonusar och kampanjer från spelpartners är föremål för förändringar och regleras av varje individuell operatörs villkor. Vi strävar efter att tillhandahålla korrekt och aktuell information, men vi kan inte garantera tillgängligheten eller villkoren för något erbjudande.",
        },
        partnerOffers: {
          title: "Partnererbjudanden",
          description: "Alla välkomstbonusar, kampanjer och erbjudanden som visas på {siteName} är föremål för:",
          items: [
            "Villkoren för den respektive speloperatören",
            "Behörighetskrav som fastställts av varje operatör",
            "Tillgänglighet vid tidpunkten för din registrering",
            "Geografiska begränsningar och licenskrav",
          ],
          recommendation: "Vi rekommenderar att du granskar de fullständiga villkoren på operatörens webbplats innan du gör anspråk på något erbjudande.",
        },
        licensing: {
          title: "Licensstatus",
          description: "{siteName} visar licensinformation för spelpartners när det är tillgängligt. Vi gör vårt bästa för att verifiera licensstatus, men operatörer kan inneha licenser från olika jurisdiktioner. Det är ditt ansvar att verifiera att någon operatör är licensierad och reglerad i din jurisdiktion innan du placerar vad.",
        },
        affiliate: {
          title: "Affiliate-Relationer",
          description: "{siteName} upprätthåller affiliate-relationer med speloperatörerna som visas på vår plattform. Detta betyder att vi kan få ersättning när användare klickar och registrerar sig hos dessa operatörer. Detta påverkar inte vårt åtagande att tillhandahålla ärliga och transparenta rekommendationer.",
        },
        noGuarantees: {
          title: "Inga Garantier",
          description: "{siteName} garanterar inte:",
          items: [
            "Tillgängligheten för något specifikt erbjudande eller bonus",
            "Noggrannheten i bonus- eller kampanjinformation",
            "Resultaten av någon transaktion med en operatör",
            "Den kontinuerliga tillgängligheten för någon operatör på vår plattform",
          ],
        },
        responsible: {
          title: "Ansvarsfullt Spelande",
          description: "Spelande kan vara beroendeframkallande. {siteName} är dedikerad till att marknadsföra ansvarsfullt spelande. Vi rekommenderar starkt:",
          items: [
            "Aldrig spela mer än du har råd att förlora",
            "Sätta tids- och pengagränser innan du börjar",
            "Aldrig spela under påverkan av alkohol eller droger",
            "Söka hjälp om du tror att du har ett spelproblem",
          ],
          helpText: "Om du behöver hjälp med problematiskt spelande, kontakta BeGambleAware eller GamCare för support och resurser.",
        },
        ageRestrictions: {
          title: "Åldersbegränsningar",
          description: "Alla operatörer som visas på {siteName} kräver att användare är minst 18 år gamla för att registrera sig och placera vad. Det är ditt ansvar att säkerställa att du uppfyller de lagliga ålderskraven i din jurisdiktion.",
        },
        liability: {
          title: "Ansvarighetsbegränsning",
          description: "{siteName} är inte ansvarig för:",
          items: [
            "Någon ekonomisk förlust som uppstår från användningen av våra rekommendationer",
            "Handlingar eller underlåtelser från någon speloperatör",
            "Ändringar i bonusvillkor eller erbjudanden",
            "Något tekniskt problem som uppstår vid åtkomst till operatörswebbplatser",
          ],
        },
        contact: {
          title: "Kontakta Oss",
          description: "Om du har frågor om dessa villkor, kontakta oss på",
          lastUpdated: "Senast uppdaterad:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Vanliga Frågor",
      subtitle: "Hitta svar på vanliga frågor om våra tjänster och spelpartners.",
      items: [
        {
          question: "Hur väljer ni era spelpartners?",
          answer: "Vi genomför en grundlig manuell verifiering av varje operatör, där vi granskar efterlevnadshistorik, tydlighet i bonusvillkor, mobil användarupplevelse och regelverksföljande. Endast operatörer som uppfyller våra strikta standarder godkänns.",
        },
        {
          question: "Är bonusar garanterade?",
          answer: "Nej, vi kan inte garantera tillgängligheten av bonusar. Alla bonusar och erbjudanden är föremål för förändringar och regleras av varje operatörs villkor. Vi rekommenderar att kontrollera operatörens webbplats för de senaste villkoren innan du gör anspråk på en bonus.",
        },
        {
          question: "Hur fungerar klickspårning?",
          answer: "Vi använder spårningsparametrar (som gclid) för att analysera vilka partnerlänkar som klickas på. Dessa data är anonymiserade och används endast för att förbättra våra tjänster och förstå användar beteende. Denna information säljs eller delas aldrig med tredje part.",
        },
        {
          question: "Får ni ersättning från partners?",
          answer: "Ja, vi upprätthåller affiliate-relationer med de visade operatörerna. Detta betyder att vi kan få ersättning när användare klickar och registrerar sig via våra länkar. Detta påverkar inte vårt åtagande att tillhandahålla ärliga och transparenta rekommendationer.",
        },
        {
          question: "Hur ofta uppdateras partnererbjudanden?",
          answer: "Vi granskar och uppdaterar regelbundet partnerinformation, bonusar och erbjudanden. Alla erbjudanden kan dock ändras av operatörer, så vi rekommenderar att kontrollera operatörens webbplats för de senaste villkoren innan du gör anspråk på en bonus.",
        },
        {
          question: "Är min personliga information säker?",
          answer: "Ja, vi tar dataskydd på allvar. Vi säljer aldrig användardata och alla analyser är anonymiserade. Vi följer GDPR-krav och Google Ads-policyer för att säkerställa att din integritet skyddas.",
        },
        {
          question: "Kan jag lita på era rekommendationer?",
          answer: "Absolut. Våra rekommendationer är baserade på grundlig analys av licens, efterlevnadshistorik, bonusvillkor och användarupplevelse. Vi upprätthåller transparens om affiliate-relationer och prioriterar dina bästa intressen.",
        },
      ],
    },
    positionLabels: [
      "Toppval",
      "Redaktörens Val",
      "Bästa Match",
      "Rekommenderad",
      "Bra Möjlighet",
      "Sjätte Möjlighet",
      "Sjunde Möjlighet",
      "Åttonde Möjlighet",
      "Nionde Möjlighet",
      "Tionde Möjlighet",
      "Elfte Möjlighet",
    ],
  },
  es: {
    hero: {
      badge: "Información de Partners Verificados",
      tagline: "Mejores Plataformas de Apuestas UK",
      slidingText: [
        "Certificado y Protegido",
        "Sitios de Retiro el Mismo Día",
        "Documentación Mínima Requerida",
        "Juego con Prioridad en Privacidad",
      ],
    },
    features: {
      badge: "Plataforma Confiable",
      title: "¿Por Qué Confiar en ReviewMasters?",
      subtitle: "Estamos comprometidos a brindarte la mejor experiencia de apuestas",
      ultraRapido: {
        title: "Ultra-rápido",
        description: "Optimización de Core Web Vitals en LCP, CLS y FID. Nuestra plataforma se carga en menos de 2 segundos, garantizando acceso instantáneo a las mejores oportunidades de apuestas sin retrasos ni interrupciones.",
      },
      conforme: {
        title: "Conforme",
        description: "Verificación manual de partners para asegurar el cumplimiento de las políticas de Google Ads. Cada operador se somete a una revisión rigurosa de licencias, claridad de términos de bonos y cumplimiento regulatorio antes de la aprobación.",
      },
      mobileFirst: {
        title: "Mobile-first",
        description: "Componentes inspirados en Material que convierten en cualquier dispositivo. Optimizado para smartphones y tablets con diseño responsive, garantizando experiencias de apuestas fluidas tanto en casa como en movimiento.",
      },
      transparente: {
        title: "Transparente",
        description: "Divulgación clara del estado de licencia para elecciones responsables. Proporcionamos total transparencia sobre credenciales de operadores, términos de bonos y relaciones de afiliados para que puedas tomar decisiones informadas con confianza.",
      },
    },
    partners: {
      heading: "Mejores Ofertas de Apuestas UK 2025",
      claimNow: "Reclamar Ahora",
      terms: "18+ Se aplican términos. Por favor, apuesta de manera responsable.",
      welcomeBonus: "Bono de Bienvenida",
    },
    footer: {
      contact: "Contacto",
      email: "Email:",
      phone: "Teléfono:",
      address: "Dirección:",
      compliance: "Cumplimiento",
      quickLinks: "Enlaces Rápidos",
      home: "Inicio",
      about: "Acerca de Nosotros",
      contactPage: "Contacto",
      legal: "Legal",
      terms: "Términos y Condiciones",
      privacy: "Política de Privacidad",
      responsibleGambling: "Juego Responsable",
    },
    navigation: {
      home: "Inicio",
      about: "Acerca de",
      contact: "Contacto",
    },
    about: {
      badge: "Acerca de Nosotros",
      title: "Acerca de {siteName}",
      subtitle: "{siteName} existe para conectar a los apostadores UK con ofertas transparentes y promovidas de manera responsable por casas de apuestas y bookmakers. Nuestro equipo analiza el historial de cumplimiento, términos de bonos y UX móvil de cada operador para garantizar que puedas ejecutar campañas de Google Ads con confianza.",
      mission: {
        title: "Nuestra Misión",
        description: "Abogar por el juego seguro y responsable mientras ayudamos a los partners a crear viajes de adquisición de clase mundial.",
      },
      compliance: {
        title: "Cumplimiento Primero",
        description: "Auditamos creativos y páginas de destino según las directrices de UKGC y las políticas de Google Ads antes de su aprobación.",
      },
      dataDriven: {
        title: "Pruebas Basadas en Datos",
        description: "Paneles de rendimiento y datos de conversión (vinculados a gclid) impulsan revisiones semanales de partners.",
      },
      commitment: {
        title: "Nuestro Compromiso",
        description: "Estamos dedicados a crear una plataforma confiable que conecte a los apostadores UK con las mejores oportunidades de apuestas, manteniendo los más altos estándares de cumplimiento y transparencia.",
      },
      trust: {
        title: "Confianza y Transparencia",
        description: "Cada partner se verifica cuidadosamente para licencias, claridad de términos de bonos y calidad de experiencia de usuario. Creemos en la total transparencia sobre el estado del operador y los detalles de las ofertas.",
      },
      performance: {
        title: "Excelencia en Rendimiento",
        description: "Nuestra plataforma está optimizada para velocidad, capacidad de respuesta móvil y conversión. Rastreamos métricas de rendimiento para mejorar continuamente la experiencia de los partners de apuestas.",
      },
    },
    contact: {
      badge: "Ponerse en Contacto",
      title: "Colaboremos juntos",
      subtitle: "Comparte tus objetivos de campaña y recomendaremos el mejor posicionamiento de partner, bono y plan de seguimiento.",
      formTitle: "Envíanos un mensaje",
      formDescription: "Completa el formulario a continuación y te responderemos en 24 horas.",
      contactDetails: "Detalles de Contacto",
      email: "Email",
      phone: "Teléfono",
      address: "Dirección",
    },
    privacy: {
      title: "Política de Privacidad",
      subtitle: "Tu privacidad es importante para nosotros. Esta política explica cómo recopilamos, usamos y protegemos tu información.",
      badge: "Legal",
      sections: {
        informationWeCollect: {
          title: "Información que Recopilamos",
          description: "{siteName} recopila información mínima necesaria para brindar nuestros servicios. Podemos recopilar:",
          items: [
            "Información de contacto cuando envías un formulario (nombre, dirección de email)",
            "Datos de uso a través de análisis anónimos para mejorar nuestro sitio web",
            "Datos de seguimiento de visitantes (URLs de entrada, información de referer, marcas de tiempo) para entender el comportamiento del usuario",
            "Datos de seguimiento de clics para analizar qué enlaces de partners se hacen clic y mejorar nuestros servicios",
            "Información técnica como dirección IP, tipo de navegador e información del dispositivo",
          ],
        },
        howWeUse: {
          title: "Cómo Usamos Tu Información",
          description: "Usamos la información que recopilamos para:",
          items: [
            "Responder a tus consultas y brindar soporte al cliente",
            "Mejorar el rendimiento de nuestro sitio web y la experiencia del usuario",
            "Rastrear interacciones de visitantes y patrones de clics para mejorar nuestros servicios",
            "Asegurar el cumplimiento de las políticas de Google Ads y las regulaciones de juego UK",
            "Analizar patrones de tráfico del sitio web a través de datos anónimos",
          ],
        },
        dataProtection: {
          title: "Protección de Datos",
          description: "Nunca vendemos datos de usuarios. Todos los análisis están anonimizados y basados en consentimiento para permanecer conformes con las políticas de Google Ads y los requisitos de GDPR. Implementamos medidas técnicas y organizativas apropiadas para proteger tu información personal.",
        },
        cookies: {
          title: "Cookies y Seguimiento",
          description: "Nuestro sitio web utiliza cookies y tecnologías de seguimiento similares para analizar el tráfico del sitio web y mejorar la experiencia del usuario. Rastreamos datos de entrada de visitantes e interacciones de clics para entender cómo los usuarios navegan por nuestro sitio y mejorar nuestros servicios. Todo el seguimiento está anonimizado y es conforme con las políticas de Google Ads. Estos datos nos ayudan a mejorar la funcionalidad del sitio web y la experiencia del usuario. Puedes controlar las preferencias de cookies a través de la configuración de tu navegador.",
        },
        thirdParty: {
          title: "Servicios de Terceros",
          description: "Podemos usar servicios de terceros para análisis y funcionalidad del sitio web. Estos servicios están sujetos a sus propias políticas de privacidad y se seleccionan por su compromiso con la protección de datos y el cumplimiento.",
        },
        yourRights: {
          title: "Tus Derechos",
          description: "Bajo GDPR, tienes derecho a:",
          items: [
            "Acceder a tus datos personales",
            "Solicitar corrección de datos inexactos",
            "Solicitar eliminación de tus datos",
            "Oponerte al procesamiento de tus datos",
            "Portabilidad de datos",
          ],
          contactText: "Para ejercer estos derechos, contáctanos en",
        },
        changes: {
          title: "Cambios a Esta Política",
          description: "Podemos actualizar esta política de privacidad de vez en cuando. Te notificaremos de cualquier cambio publicando la nueva política en esta página y actualizando la fecha de \"Última actualización\".",
        },
        contact: {
          title: "Contáctanos",
          description: "Si tienes preguntas sobre esta política de privacidad, contáctanos en",
          lastUpdated: "Última actualización:",
        },
      },
    },
    disclaimer: {
      title: "Términos y Condiciones",
      subtitle: "Información importante sobre nuestras recomendaciones de partners de apuestas y términos de uso.",
      badge: "Legal",
      sections: {
        general: {
          title: "Información General",
          description: "{siteName} promueve operadores con licencia siempre que sea posible. Todas las ofertas, bonos y promociones de partners de apuestas están sujetas a cambios y se rigen por los términos y condiciones de cada operador individual. Nos esforzamos por proporcionar información precisa y actualizada, pero no podemos garantizar la disponibilidad o términos de ninguna oferta.",
        },
        partnerOffers: {
          title: "Ofertas de Partners",
          description: "Todos los bonos de bienvenida, promociones y ofertas mostradas en {siteName} están sujetas a:",
          items: [
            "Los términos y condiciones del operador de apuestas respectivo",
            "Requisitos de elegibilidad establecidos por cada operador",
            "Disponibilidad en el momento de tu registro",
            "Restricciones geográficas y requisitos de licencia",
          ],
          recommendation: "Recomendamos que revises los términos y condiciones completos en el sitio web del operador antes de reclamar cualquier oferta.",
        },
        licensing: {
          title: "Estado de Licencia",
          description: "{siteName} muestra información de licencia para partners de apuestas cuando está disponible. Hacemos todo lo posible para verificar el estado de licencia, pero los operadores pueden tener licencias de diferentes jurisdicciones. Es tu responsabilidad verificar que cualquier operador esté licenciado y regulado en tu jurisdicción antes de realizar apuestas.",
        },
        affiliate: {
          title: "Relaciones de Afiliados",
          description: "{siteName} mantiene relaciones de afiliados con los operadores de apuestas presentados en nuestra plataforma. Esto significa que podemos recibir compensación cuando los usuarios hacen clic y se registran con estos operadores. Esto no afecta nuestro compromiso de proporcionar recomendaciones honestas y transparentes.",
        },
        noGuarantees: {
          title: "Sin Garantías",
          description: "{siteName} no garantiza:",
          items: [
            "La disponibilidad de cualquier oferta o bono específico",
            "La precisión de la información de bonos o promociones",
            "Los resultados de cualquier transacción con un operador",
            "La disponibilidad continua de cualquier operador en nuestra plataforma",
          ],
        },
        responsible: {
          title: "Juego Responsable",
          description: "El juego puede ser adictivo. {siteName} está comprometido a promover el juego responsable. Recomendamos encarecidamente:",
          items: [
            "Nunca apostar más de lo que puedes permitirte perder",
            "Establecer límites de tiempo y dinero antes de comenzar",
            "Nunca jugar bajo la influencia del alcohol o drogas",
            "Buscar ayuda si crees que tienes un problema de juego",
          ],
          helpText: "Si necesitas ayuda con el juego problemático, contacta a BeGambleAware o GamCare para obtener apoyo y recursos.",
        },
        ageRestrictions: {
          title: "Restricciones de Edad",
          description: "Todos los operadores mostrados en {siteName} requieren que los usuarios tengan al menos 18 años para registrarse y realizar apuestas. Es tu responsabilidad asegurarte de cumplir con los requisitos de edad legales en tu jurisdicción.",
        },
        liability: {
          title: "Limitación de Responsabilidad",
          description: "{siteName} no es responsable de:",
          items: [
            "Cualquier pérdida financiera resultante del uso de nuestras recomendaciones",
            "Las acciones u omisiones de cualquier operador de apuestas",
            "Los cambios en los términos de bonos o ofertas",
            "Cualquier problema técnico encontrado al acceder a los sitios de operadores",
          ],
        },
        contact: {
          title: "Contáctanos",
          description: "Si tienes preguntas sobre estos términos y condiciones, contáctanos en",
          lastUpdated: "Última actualización:",
        },
      },
    },
    faq: {
      badge: "FAQ",
      title: "Preguntas Frecuentes",
      subtitle: "Encuentra respuestas a preguntas comunes sobre nuestros servicios y partners de apuestas.",
      items: [
        {
          question: "¿Cómo seleccionan sus partners de apuestas?",
          answer: "Realizamos una verificación manual exhaustiva de cada operador, revisando el historial de cumplimiento, claridad de términos de bonos, experiencia de usuario móvil y cumplimiento regulatorio. Solo se aprueban los operadores que cumplen con nuestros estándares estrictos.",
        },
        {
          question: "¿Están garantizados los bonos?",
          answer: "No, no podemos garantizar la disponibilidad de bonos. Todos los bonos y ofertas están sujetos a cambios y se rigen por los términos y condiciones de cada operador. Recomendamos verificar el sitio web del operador para los términos más recientes antes de reclamar un bono.",
        },
        {
          question: "¿Cómo funciona el seguimiento de clics?",
          answer: "Utilizamos parámetros de seguimiento (como gclid) para analizar qué enlaces de partners se hacen clic. Estos datos están anonimizados y se usan solo para mejorar nuestros servicios y entender el comportamiento del usuario. Esta información nunca se vende ni se comparte con terceros.",
        },
        {
          question: "¿Reciben compensación de los partners?",
          answer: "Sí, mantenemos relaciones de afiliados con los operadores mostrados. Esto significa que podemos recibir compensación cuando los usuarios hacen clic y se registran a través de nuestros enlaces. Esto no afecta nuestro compromiso de proporcionar recomendaciones honestas y transparentes.",
        },
        {
          question: "¿Con qué frecuencia se actualizan las ofertas de partners?",
          answer: "Revisamos y actualizamos regularmente la información, bonos y ofertas de partners. Sin embargo, todas las ofertas pueden ser modificadas por los operadores, por lo que recomendamos verificar el sitio web del operador para los términos más recientes antes de reclamar un bono.",
        },
        {
          question: "¿Está segura mi información personal?",
          answer: "Sí, nos tomamos en serio la protección de datos. Nunca vendemos datos de usuarios y todos los análisis están anonimizados. Cumplimos con los requisitos de GDPR y las políticas de Google Ads para garantizar que tu privacidad esté protegida.",
        },
        {
          question: "¿Puedo confiar en sus recomendaciones?",
          answer: "Absolutamente. Nuestras recomendaciones se basan en un análisis exhaustivo de licencias, historial de cumplimiento, términos de bonos y experiencia de usuario. Mantenemos transparencia sobre las relaciones de afiliados y priorizamos tus mejores intereses.",
        },
      ],
    },
    positionLabels: [
      "Top Elección",
      "Elección del Editor",
      "Mejor Coincidencia",
      "Recomendado",
      "Buena Oportunidad",
      "Sexta Oportunidad",
      "Séptima Oportunidad",
      "Octava Oportunidad",
      "Novena Oportunidad",
      "Décima Oportunidad",
      "Undécima Oportunidad",
    ],
  },
} as const;

/**
 * Gets translations for a specific language
 */
export function getTranslations(lang: LanguageCode): Translations {
  return translations[lang];
}

/**
 * Gets a specific translation key
 */
export function t(lang: LanguageCode): Translations {
  return getTranslations(lang);
}

