"use client";

import { useEffect } from "react";

/**
 * Client-side component to track visitor entry URLs
 * Runs once when the page loads to capture the entry URL
 */
export function VisitorTracker() {
  useEffect(() => {
    // Only track on client side
    if (typeof window === "undefined") return;

    // Get the full URL including query parameters
    const entryUrl = window.location.href;
    const userAgent = navigator.userAgent;
    const referer = document.referrer || null;

    // Track visitor asynchronously without blocking page load
    fetch("/api/visitors", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({
        url: entryUrl,
        userAgent: userAgent,
        referer: referer,
      }),
    }).catch((error) => {
      // Silently fail - don't block user experience
      console.error("Failed to track visitor:", error);
    });
  }, []);

  return null; // This component doesn't render anything
}

